/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.regex.Pattern;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.Anchor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ArrayStack;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.CharConstants;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.UriEncoder;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.ScannerException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.Scanner;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.SimpleKey;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner.StreamReader;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.AliasToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.AnchorToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.BlockEndToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.BlockEntryToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.BlockMappingStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.BlockSequenceStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.CommentToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.DirectiveToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.DocumentEndToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.DocumentStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.FlowEntryToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.FlowMappingEndToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.FlowMappingStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.FlowSequenceEndToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.FlowSequenceStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.KeyToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.ScalarToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.StreamEndToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.StreamStartToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.TagToken;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.TagTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.Token;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.tokens.ValueToken;

public final class ScannerImpl
implements Scanner {
    private static final String DIRECTIVE_PREFIX = "while scanning a directive";
    private static final String EXPECTED_ALPHA_ERROR_PREFIX = "expected alphabetic or numeric character, but found ";
    private static final String SCANNING_SCALAR = "while scanning a block scalar";
    private static final String SCANNING_PREFIX = "while scanning a ";
    private static final Pattern NOT_HEXA = Pattern.compile("[^0-9A-Fa-f]");
    private final StreamReader reader;
    private final List<Token> tokens;
    private final ArrayStack<Integer> indents;
    private final Map<Integer, SimpleKey> possibleSimpleKeys;
    private final LoadSettings settings;
    private boolean done = false;
    private int flowLevel = 0;
    private Token lastToken;
    private int tokensTaken = 0;
    private int indent = -1;
    private boolean allowSimpleKey = true;

    @Deprecated
    public ScannerImpl(StreamReader streamReader, LoadSettings loadSettings) {
        this(loadSettings, streamReader);
    }

    public ScannerImpl(LoadSettings loadSettings, StreamReader streamReader) {
        this.reader = streamReader;
        this.settings = loadSettings;
        this.tokens = new ArrayList<Token>(100);
        this.indents = new ArrayStack(10);
        this.possibleSimpleKeys = new LinkedHashMap<Integer, SimpleKey>();
        this.fetchStreamStart();
    }

    @Deprecated
    public ScannerImpl(StreamReader streamReader) {
        this(LoadSettings.builder().build(), streamReader);
    }

    @Override
    public boolean checkToken(Token.ID ... iDArray) {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        if (!this.tokens.isEmpty()) {
            if (iDArray.length == 0) {
                return true;
            }
            Token token = this.tokens.get(0);
            Token.ID iD = token.getTokenId();
            for (int i = 0; i < iDArray.length; ++i) {
                if (iD != iDArray[i]) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Token peekToken() {
        while (this.needMoreTokens()) {
            this.fetchMoreTokens();
        }
        return this.tokens.get(0);
    }

    @Override
    public boolean hasNext() {
        return this.checkToken(new Token.ID[0]);
    }

    @Override
    public Token next() {
        ++this.tokensTaken;
        if (this.tokens.isEmpty()) {
            throw new NoSuchElementException("No more Tokens found.");
        }
        return this.tokens.remove(0);
    }

    private void addToken(Token token) {
        this.lastToken = token;
        this.tokens.add(token);
    }

    private void addToken(int n, Token token) {
        if (n == this.tokens.size()) {
            this.lastToken = token;
        }
        this.tokens.add(n, token);
    }

    private void addAllTokens(List<Token> list) {
        this.lastToken = list.get(list.size() - 1);
        this.tokens.addAll(list);
    }

    private boolean isBlockContext() {
        return this.flowLevel == 0;
    }

    private boolean isFlowContext() {
        return !this.isBlockContext();
    }

    private boolean needMoreTokens() {
        if (this.done) {
            return false;
        }
        if (this.tokens.isEmpty()) {
            return true;
        }
        this.stalePossibleSimpleKeys();
        return this.nextPossibleSimpleKey() == this.tokensTaken;
    }

    private void fetchMoreTokens() {
        if (this.reader.getDocumentIndex() > this.settings.getCodePointLimit()) {
            throw new YamlEngineException("The incoming YAML document exceeds the limit: " + this.settings.getCodePointLimit() + " code points.");
        }
        this.scanToNextToken();
        this.stalePossibleSimpleKeys();
        this.unwindIndent(this.reader.getColumn());
        int n = this.reader.peek();
        switch (n) {
            case 0: {
                this.fetchStreamEnd();
                return;
            }
            case 37: {
                if (!this.checkDirective()) break;
                this.fetchDirective();
                return;
            }
            case 45: {
                if (this.checkDocumentStart()) {
                    this.fetchDocumentStart();
                    return;
                }
                if (!this.checkBlockEntry()) break;
                this.fetchBlockEntry();
                return;
            }
            case 46: {
                if (!this.checkDocumentEnd()) break;
                this.fetchDocumentEnd();
                return;
            }
            case 91: {
                this.fetchFlowSequenceStart();
                return;
            }
            case 123: {
                this.fetchFlowMappingStart();
                return;
            }
            case 93: {
                this.fetchFlowSequenceEnd();
                return;
            }
            case 125: {
                this.fetchFlowMappingEnd();
                return;
            }
            case 44: {
                this.fetchFlowEntry();
                return;
            }
            case 63: {
                if (!this.checkKey()) break;
                this.fetchKey();
                return;
            }
            case 58: {
                if (!this.checkValue()) break;
                this.fetchValue();
                return;
            }
            case 42: {
                this.fetchAlias();
                return;
            }
            case 38: {
                this.fetchAnchor();
                return;
            }
            case 33: {
                this.fetchTag();
                return;
            }
            case 124: {
                if (!this.isBlockContext()) break;
                this.fetchLiteral();
                return;
            }
            case 62: {
                if (!this.isBlockContext()) break;
                this.fetchFolded();
                return;
            }
            case 39: {
                this.fetchSingle();
                return;
            }
            case 34: {
                this.fetchDouble();
                return;
            }
        }
        if (this.checkPlain()) {
            this.fetchPlain();
            return;
        }
        String string = CharConstants.escapeChar(String.valueOf(Character.toChars(n)));
        if (n == 9) {
            string = string + "(TAB)";
        }
        String string2 = String.format("found character '%s' that cannot start any token. (Do not use %s for indentation)", string, string);
        throw new ScannerException("while scanning for the next token", Optional.empty(), string2, this.reader.getMark());
    }

    private int nextPossibleSimpleKey() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            return this.possibleSimpleKeys.values().iterator().next().getTokenNumber();
        }
        return -1;
    }

    private void stalePossibleSimpleKeys() {
        if (!this.possibleSimpleKeys.isEmpty()) {
            Iterator<SimpleKey> iterator = this.possibleSimpleKeys.values().iterator();
            while (iterator.hasNext()) {
                SimpleKey simpleKey = iterator.next();
                if (simpleKey.getLine() == this.reader.getLine() && this.reader.getIndex() - simpleKey.getIndex() <= 1024) continue;
                if (simpleKey.isRequired()) {
                    throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
                }
                iterator.remove();
            }
        }
    }

    private void savePossibleSimpleKey() {
        boolean bl;
        boolean bl2 = bl = this.isBlockContext() && this.indent == this.reader.getColumn();
        if (!this.allowSimpleKey && bl) {
            throw new YamlEngineException("A simple key is required only if it is the first token in the current line");
        }
        if (this.allowSimpleKey) {
            this.removePossibleSimpleKey();
            int n = this.tokensTaken + this.tokens.size();
            SimpleKey simpleKey = new SimpleKey(n, bl, this.reader.getIndex(), this.reader.getLine(), this.reader.getColumn(), this.reader.getMark());
            this.possibleSimpleKeys.put(this.flowLevel, simpleKey);
        }
    }

    private void removePossibleSimpleKey() {
        SimpleKey simpleKey = this.possibleSimpleKeys.remove(this.flowLevel);
        if (simpleKey != null && simpleKey.isRequired()) {
            throw new ScannerException("while scanning a simple key", simpleKey.getMark(), "could not find expected ':'", this.reader.getMark());
        }
    }

    private void unwindIndent(int n) {
        if (this.isFlowContext()) {
            return;
        }
        while (this.indent > n) {
            Optional<Mark> optional = this.reader.getMark();
            this.indent = this.indents.pop();
            this.addToken(new BlockEndToken(optional, optional));
        }
    }

    private boolean addIndent(int n) {
        if (this.indent < n) {
            this.indents.push(this.indent);
            this.indent = n;
            return true;
        }
        return false;
    }

    private void fetchStreamStart() {
        Optional<Mark> optional = this.reader.getMark();
        StreamStartToken streamStartToken = new StreamStartToken(optional, optional);
        this.addToken(streamStartToken);
    }

    private void fetchStreamEnd() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        this.possibleSimpleKeys.clear();
        Optional<Mark> optional = this.reader.getMark();
        StreamEndToken streamEndToken = new StreamEndToken(optional, optional);
        this.addToken(streamEndToken);
        this.done = true;
    }

    private void fetchDirective() {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        List<Token> list = this.scanDirective();
        this.addAllTokens(list);
    }

    private void fetchDocumentStart() {
        this.fetchDocumentIndicator(true);
    }

    private void fetchDocumentEnd() {
        this.fetchDocumentIndicator(false);
    }

    private void fetchDocumentIndicator(boolean bl) {
        this.unwindIndent(-1);
        this.removePossibleSimpleKey();
        this.allowSimpleKey = false;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward(3);
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl ? new DocumentStartToken(optional, optional2) : new DocumentEndToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowSequenceStart() {
        this.fetchFlowCollectionStart(false);
    }

    private void fetchFlowMappingStart() {
        this.fetchFlowCollectionStart(true);
    }

    private void fetchFlowCollectionStart(boolean bl) {
        this.savePossibleSimpleKey();
        ++this.flowLevel;
        this.allowSimpleKey = true;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward(1);
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl ? new FlowMappingStartToken(optional, optional2) : new FlowSequenceStartToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowSequenceEnd() {
        this.fetchFlowCollectionEnd(false);
    }

    private void fetchFlowMappingEnd() {
        this.fetchFlowCollectionEnd(true);
    }

    private void fetchFlowCollectionEnd(boolean bl) {
        this.removePossibleSimpleKey();
        --this.flowLevel;
        this.allowSimpleKey = false;
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl ? new FlowMappingEndToken(optional, optional2) : new FlowSequenceEndToken(optional, optional2);
        this.addToken(token);
    }

    private void fetchFlowEntry() {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        FlowEntryToken flowEntryToken = new FlowEntryToken(optional, optional2);
        this.addToken(flowEntryToken);
    }

    private void fetchBlockEntry() {
        Optional<Mark> optional;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("", Optional.empty(), "sequence entries are not allowed here", this.reader.getMark());
            }
            if (this.addIndent(this.reader.getColumn())) {
                optional = this.reader.getMark();
                this.addToken(new BlockSequenceStartToken(optional, optional));
            }
        }
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        BlockEntryToken blockEntryToken = new BlockEntryToken(optional, optional2);
        this.addToken(blockEntryToken);
    }

    private void fetchKey() {
        Optional<Mark> optional;
        if (this.isBlockContext()) {
            if (!this.allowSimpleKey) {
                throw new ScannerException("mapping keys are not allowed here", this.reader.getMark());
            }
            if (this.addIndent(this.reader.getColumn())) {
                optional = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(optional, optional));
            }
        }
        this.allowSimpleKey = this.isBlockContext();
        this.removePossibleSimpleKey();
        optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        KeyToken keyToken = new KeyToken(optional, optional2);
        this.addToken(keyToken);
    }

    private void fetchValue() {
        Optional<Mark> optional;
        SimpleKey simpleKey = this.possibleSimpleKeys.remove(this.flowLevel);
        if (simpleKey != null) {
            this.addToken(simpleKey.getTokenNumber() - this.tokensTaken, new KeyToken(simpleKey.getMark(), simpleKey.getMark()));
            if (this.isBlockContext() && this.addIndent(simpleKey.getColumn())) {
                this.addToken(simpleKey.getTokenNumber() - this.tokensTaken, new BlockMappingStartToken(simpleKey.getMark(), simpleKey.getMark()));
            }
            this.allowSimpleKey = false;
        } else {
            if (this.isBlockContext() && !this.allowSimpleKey) {
                throw new ScannerException("mapping values are not allowed here", this.reader.getMark());
            }
            if (this.isBlockContext() && this.addIndent(this.reader.getColumn())) {
                optional = this.reader.getMark();
                this.addToken(new BlockMappingStartToken(optional, optional));
            }
            this.allowSimpleKey = this.isBlockContext();
            this.removePossibleSimpleKey();
        }
        optional = this.reader.getMark();
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        ValueToken valueToken = new ValueToken(optional, optional2);
        this.addToken(valueToken);
    }

    private void fetchAlias() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(false);
        this.addToken(token);
    }

    private void fetchAnchor() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanAnchor(true);
        this.addToken(token);
    }

    private void fetchTag() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanTag();
        this.addToken(token);
    }

    private void fetchLiteral() {
        this.fetchBlockScalar(ScalarStyle.LITERAL);
    }

    private void fetchFolded() {
        this.fetchBlockScalar(ScalarStyle.FOLDED);
    }

    private void fetchBlockScalar(ScalarStyle scalarStyle) {
        this.allowSimpleKey = true;
        this.removePossibleSimpleKey();
        List<Token> list = this.scanBlockScalar(scalarStyle);
        this.addAllTokens(list);
    }

    private void fetchSingle() {
        this.fetchFlowScalar(ScalarStyle.SINGLE_QUOTED);
    }

    private void fetchDouble() {
        this.fetchFlowScalar(ScalarStyle.DOUBLE_QUOTED);
    }

    private void fetchFlowScalar(ScalarStyle scalarStyle) {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanFlowScalar(scalarStyle);
        this.addToken(token);
    }

    private void fetchPlain() {
        this.savePossibleSimpleKey();
        this.allowSimpleKey = false;
        Token token = this.scanPlain();
        this.addToken(token);
    }

    private boolean checkDirective() {
        return this.reader.getColumn() == 0;
    }

    private boolean checkDocumentStart() {
        if (this.reader.getColumn() == 0) {
            return "---".equals(this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkDocumentEnd() {
        if (this.reader.getColumn() == 0) {
            return "...".equals(this.reader.prefix(3)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3));
        }
        return false;
    }

    private boolean checkBlockEntry() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkKey() {
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkValue() {
        if (this.isFlowContext()) {
            return true;
        }
        return CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(1));
    }

    private boolean checkPlain() {
        int n = this.reader.peek();
        boolean bl = CharConstants.NULL_BL_T_LINEBR.hasNo(n, "-?:,[]{}#&*!|>'\"%@`");
        if (bl) {
            return true;
        }
        if (this.isBlockContext()) {
            return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1)) && "-?:".indexOf(n) != -1;
        }
        return CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(1), ",]") && "-?".indexOf(n) != -1;
    }

    private void scanToNextToken() {
        if (this.reader.getIndex() == 0 && this.reader.peek() == 65279) {
            this.reader.forward();
        }
        boolean bl = false;
        int n = -1;
        while (!bl) {
            Object object;
            Optional<Mark> optional = this.reader.getMark();
            int n2 = this.reader.getColumn();
            boolean bl2 = false;
            int n3 = 0;
            while (this.reader.peek(n3) == 32) {
                ++n3;
            }
            if (n3 > 0) {
                this.reader.forward(n3);
            }
            if (this.reader.peek() == 35) {
                bl2 = true;
                if (n2 != 0 && (this.lastToken == null || this.lastToken.getTokenId() != Token.ID.BlockEntry)) {
                    object = CommentType.IN_LINE;
                    n = this.reader.getColumn();
                } else if (n == this.reader.getColumn()) {
                    object = CommentType.IN_LINE;
                } else {
                    n = -1;
                    object = CommentType.BLOCK;
                }
                CommentToken commentToken = this.scanComment((CommentType)((Object)object));
                if (this.settings.getParseComments()) {
                    this.addToken(commentToken);
                }
            }
            if (((Optional)(object = this.scanLineBreak())).isPresent()) {
                if (this.settings.getParseComments() && !bl2 && n2 == 0) {
                    this.addToken(new CommentToken(CommentType.BLANK_LINE, (String)((Optional)object).get(), optional, this.reader.getMark()));
                }
                if (!this.isBlockContext()) continue;
                this.allowSimpleKey = true;
                continue;
            }
            bl = true;
        }
    }

    private CommentToken scanComment(CommentType commentType) {
        Optional<Mark> optional = this.reader.getMark();
        this.reader.forward();
        int n = 0;
        while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n))) {
            ++n;
        }
        String string = this.reader.prefixForward(n);
        Optional<Mark> optional2 = this.reader.getMark();
        return new CommentToken(commentType, string, optional, optional2);
    }

    private List<Token> scanDirective() {
        Optional<Mark> optional;
        Optional<List<Object>> optional2;
        Optional<Mark> optional3 = this.reader.getMark();
        this.reader.forward();
        String string = this.scanDirectiveName(optional3);
        if ("YAML".equals(string)) {
            optional2 = Optional.of(this.scanYamlDirectiveValue(optional3));
            optional = this.reader.getMark();
        } else if ("TAG".equals(string)) {
            optional2 = Optional.of(this.scanTagDirectiveValue(optional3));
            optional = this.reader.getMark();
        } else {
            optional = this.reader.getMark();
            int n = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n))) {
                ++n;
            }
            if (n > 0) {
                this.reader.forward(n);
            }
            optional2 = Optional.empty();
        }
        CommentToken commentToken = this.scanDirectiveIgnoredLine(optional3);
        DirectiveToken directiveToken = new DirectiveToken(string, optional2, optional3, optional);
        return this.makeTokenList(directiveToken, commentToken);
    }

    private String scanDirectiveName(Optional<Mark> optional) {
        int n = 0;
        int n2 = this.reader.peek(n);
        while (CharConstants.ALPHA.has(n2)) {
            n2 = this.reader.peek(++n);
        }
        if (n == 0) {
            String string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, EXPECTED_ALPHA_ERROR_PREFIX + string + "(" + n2 + ")", this.reader.getMark());
        }
        String string = this.reader.prefixForward(n);
        n2 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n2)) {
            String string2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, EXPECTED_ALPHA_ERROR_PREFIX + string2 + "(" + n2 + ")", this.reader.getMark());
        }
        return string;
    }

    private List<Integer> scanYamlDirectiveValue(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        Integer n = this.scanYamlDirectiveNumber(optional);
        int n2 = this.reader.peek();
        if (n2 != 46) {
            String string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit or '.', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        this.reader.forward();
        Integer n3 = this.scanYamlDirectiveNumber(optional);
        n2 = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n2)) {
            String string = String.valueOf(Character.toChars(n2));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit or ' ', but found " + string + "(" + n2 + ")", this.reader.getMark());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
        arrayList.add(n);
        arrayList.add(n3);
        return arrayList;
    }

    private Integer scanYamlDirectiveNumber(Optional<Mark> optional) {
        int n = this.reader.peek();
        if (!Character.isDigit(n)) {
            String string = String.valueOf(Character.toChars(n));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a digit, but found " + string + "(" + n + ")", this.reader.getMark());
        }
        int n2 = 0;
        while (Character.isDigit(this.reader.peek(n2))) {
            ++n2;
        }
        String string = this.reader.prefixForward(n2);
        if (n2 > 3) {
            throw new ScannerException("while scanning a YAML directive", optional, "found a number which cannot represent a valid version: " + string, this.reader.getMark());
        }
        Integer n3 = Integer.parseInt(string);
        return n3;
    }

    private List<String> scanTagDirectiveValue(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String string = this.scanTagDirectiveHandle(optional);
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        String string2 = this.scanTagDirectivePrefix(optional);
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(string);
        arrayList.add(string2);
        return arrayList;
    }

    private String scanTagDirectiveHandle(Optional<Mark> optional) {
        String string = this.scanTagHandle("directive", optional);
        int n = this.reader.peek();
        if (n != 32) {
            String string2 = String.valueOf(Character.toChars(n));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected ' ', but found " + string2 + "(" + n + ")", this.reader.getMark());
        }
        return string;
    }

    private String scanTagDirectivePrefix(Optional<Mark> optional) {
        String string = this.scanTagUri("directive", CharConstants.URI_CHARS_FOR_TAG_PREFIX, optional);
        int n = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n)) {
            String string2 = String.valueOf(Character.toChars(n));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected ' ', but found " + string2 + "(" + n + ")", this.reader.getMark());
        }
        return string;
    }

    private CommentToken scanDirectiveIgnoredLine(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        CommentToken commentToken = null;
        if (this.reader.peek() == 35) {
            CommentToken commentToken2 = this.scanComment(CommentType.IN_LINE);
            if (this.settings.getParseComments()) {
                commentToken = commentToken2;
            }
        }
        int n = this.reader.peek();
        if (!this.scanLineBreak().isPresent() && n != 0) {
            String string = String.valueOf(Character.toChars(n));
            throw new ScannerException(DIRECTIVE_PREFIX, optional, "expected a comment or a line break, but found " + string + "(" + n + ")", this.reader.getMark());
        }
        return commentToken;
    }

    private Token scanAnchor(boolean bl) {
        Optional<Mark> optional = this.reader.getMark();
        int n = this.reader.peek();
        String string = n == 42 ? "alias" : "anchor";
        this.reader.forward();
        int n2 = 0;
        int n3 = this.reader.peek(n2);
        while (CharConstants.NULL_BL_T_LINEBR.hasNo(n3, ",[]{}/.*&")) {
            n3 = this.reader.peek(++n2);
        }
        if (n2 == 0) {
            String string2 = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning an " + string, optional, "unexpected character found " + string2 + "(" + n3 + ")", this.reader.getMark());
        }
        String string3 = this.reader.prefixForward(n2);
        n3 = this.reader.peek();
        if (CharConstants.NULL_BL_T_LINEBR.hasNo(n3, "?:,]}%@`")) {
            String string4 = String.valueOf(Character.toChars(n3));
            throw new ScannerException("while scanning an " + string, optional, "unexpected character found " + string4 + "(" + n3 + ")", this.reader.getMark());
        }
        Optional<Mark> optional2 = this.reader.getMark();
        Token token = bl ? new AnchorToken(new Anchor(string3), optional, optional2) : new AliasToken(new Anchor(string3), optional, optional2);
        return token;
    }

    private Token scanTag() {
        Optional<Mark> optional = this.reader.getMark();
        int n = this.reader.peek(1);
        String string = null;
        String string2 = null;
        if (n == 60) {
            this.reader.forward(2);
            string2 = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_PREFIX, optional);
            n = this.reader.peek();
            if (n != 62) {
                String string3 = String.valueOf(Character.toChars(n));
                throw new ScannerException("while scanning a tag", optional, "expected '>', but found '" + string3 + "' (" + n + ")", this.reader.getMark());
            }
            this.reader.forward();
        } else if (CharConstants.NULL_BL_T_LINEBR.has(n)) {
            string2 = "!";
            this.reader.forward();
        } else {
            int n2 = 1;
            boolean bl = false;
            while (CharConstants.NULL_BL_LINEBR.hasNo(n)) {
                if (n == 33) {
                    bl = true;
                    break;
                }
                n = this.reader.peek(++n2);
            }
            if (bl) {
                string = this.scanTagHandle("tag", optional);
            } else {
                string = "!";
                this.reader.forward();
            }
            string2 = this.scanTagUri("tag", CharConstants.URI_CHARS_FOR_TAG_SUFFIX, optional);
        }
        n = this.reader.peek();
        if (CharConstants.NULL_BL_LINEBR.hasNo(n)) {
            String string4 = String.valueOf(Character.toChars(n));
            throw new ScannerException("while scanning a tag", optional, "expected ' ', but found '" + string4 + "' (" + n + ")", this.reader.getMark());
        }
        TagTuple tagTuple = new TagTuple(Optional.ofNullable(string), string2);
        Optional<Mark> optional2 = this.reader.getMark();
        return new TagToken(tagTuple, optional, optional2);
    }

    private List<Token> scanBlockScalar(ScalarStyle scalarStyle) {
        Optional optional;
        String string;
        Optional<String> optional2;
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional3 = this.reader.getMark();
        this.reader.forward();
        Chomping chomping = this.scanBlockScalarIndicators(optional3);
        CommentToken commentToken = this.scanBlockScalarIgnoredLine(optional3);
        int n2 = this.indent + 1;
        if (n2 < 1) {
            n2 = 1;
        }
        if (chomping.increment.isPresent()) {
            n = n2 + (Integer)chomping.increment.get() - 1;
            optional2 = this.scanBlockScalarBreaks(n);
            string = ((BreakIntentHolder)((Object)optional2)).breaks;
            optional = ((BreakIntentHolder)((Object)optional2)).endMark;
        } else {
            optional2 = this.scanBlockScalarIndentation();
            string = ((BreakIntentHolder)((Object)optional2)).breaks;
            int n3 = ((BreakIntentHolder)((Object)optional2)).maxIndent;
            optional = ((BreakIntentHolder)((Object)optional2)).endMark;
            n = Math.max(n2, n3);
        }
        optional2 = Optional.empty();
        if (this.reader.getColumn() < n && this.indent != this.reader.getColumn()) {
            throw new ScannerException(SCANNING_SCALAR, optional3, " the leading empty lines contain more spaces (" + n + ") than the first non-empty line.", this.reader.getMark());
        }
        while (this.reader.getColumn() == n && this.reader.peek() != 0) {
            stringBuilder.append(string);
            boolean bl = " \t".indexOf(this.reader.peek()) == -1;
            int n4 = 0;
            while (CharConstants.NULL_OR_LINEBR.hasNo(this.reader.peek(n4))) {
                ++n4;
            }
            stringBuilder.append(this.reader.prefixForward(n4));
            optional2 = this.scanLineBreak();
            BreakIntentHolder breakIntentHolder = this.scanBlockScalarBreaks(n);
            string = breakIntentHolder.breaks;
            optional = breakIntentHolder.endMark;
            if (this.reader.getColumn() != n || this.reader.peek() == 0) break;
            if (scalarStyle == ScalarStyle.FOLDED && "\n".equals(optional2.orElse("")) && bl && " \t".indexOf(this.reader.peek()) == -1) {
                if (!string.isEmpty()) continue;
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(optional2.orElse(""));
        }
        if (chomping.value == Chomping.Indicator.CLIP || chomping.value == Chomping.Indicator.KEEP) {
            stringBuilder.append(optional2.orElse(""));
        }
        if (chomping.value == Chomping.Indicator.KEEP) {
            stringBuilder.append(string);
        }
        ScalarToken scalarToken = new ScalarToken(stringBuilder.toString(), false, scalarStyle, optional3, optional);
        return this.makeTokenList(commentToken, scalarToken);
    }

    private Chomping scanBlockScalarIndicators(Optional<Mark> optional) {
        int n;
        int n2 = Integer.MIN_VALUE;
        Optional<Integer> optional2 = Optional.empty();
        int n3 = this.reader.peek();
        if (n3 == 45 || n3 == 43) {
            n2 = n3;
            this.reader.forward();
            n3 = this.reader.peek();
            if (Character.isDigit(n3)) {
                n = Integer.parseInt(String.valueOf(Character.toChars(n3)));
                if (n == 0) {
                    throw new ScannerException(SCANNING_SCALAR, optional, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
                }
                optional2 = Optional.of(n);
                this.reader.forward();
            }
        } else if (Character.isDigit(n3)) {
            n = Integer.parseInt(String.valueOf(Character.toChars(n3)));
            if (n == 0) {
                throw new ScannerException(SCANNING_SCALAR, optional, "expected indentation indicator in the range 1-9, but found 0", this.reader.getMark());
            }
            optional2 = Optional.of(n);
            this.reader.forward();
            n3 = this.reader.peek();
            if (n3 == 45 || n3 == 43) {
                n2 = n3;
                this.reader.forward();
            }
        }
        if (CharConstants.NULL_BL_LINEBR.hasNo(n3 = this.reader.peek())) {
            String string = String.valueOf(Character.toChars(n3));
            throw new ScannerException(SCANNING_SCALAR, optional, "expected chomping or indentation indicators, but found " + string + "(" + n3 + ")", this.reader.getMark());
        }
        return new Chomping(n2, optional2);
    }

    private CommentToken scanBlockScalarIgnoredLine(Optional<Mark> optional) {
        while (this.reader.peek() == 32) {
            this.reader.forward();
        }
        CommentToken commentToken = null;
        if (this.reader.peek() == 35) {
            commentToken = this.scanComment(CommentType.IN_LINE);
        }
        int n = this.reader.peek();
        if (!this.scanLineBreak().isPresent() && n != 0) {
            String string = String.valueOf(Character.toChars(n));
            throw new ScannerException(SCANNING_SCALAR, optional, "expected a comment or a line break, but found " + string + "(" + n + ")", this.reader.getMark());
        }
        return commentToken;
    }

    private BreakIntentHolder scanBlockScalarIndentation() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Optional<Mark> optional = this.reader.getMark();
        while (CharConstants.LINEBR.has(this.reader.peek(), " \r")) {
            if (this.reader.peek() != 32) {
                stringBuilder.append(this.scanLineBreak().orElse(""));
                optional = this.reader.getMark();
                continue;
            }
            this.reader.forward();
            if (this.reader.getColumn() <= n) continue;
            n = this.reader.getColumn();
        }
        return new BreakIntentHolder(stringBuilder.toString(), n, optional);
    }

    private BreakIntentHolder scanBlockScalarBreaks(int n) {
        Optional<String> optional;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional2 = this.reader.getMark();
        for (n2 = this.reader.getColumn(); n2 < n && this.reader.peek() == 32; ++n2) {
            this.reader.forward();
        }
        while ((optional = this.scanLineBreak()).isPresent()) {
            stringBuilder.append(optional.get());
            optional2 = this.reader.getMark();
            for (n2 = this.reader.getColumn(); n2 < n && this.reader.peek() == 32; ++n2) {
                this.reader.forward();
            }
        }
        return new BreakIntentHolder(stringBuilder.toString(), -1, optional2);
    }

    private Token scanFlowScalar(ScalarStyle scalarStyle) {
        boolean bl = scalarStyle == ScalarStyle.DOUBLE_QUOTED;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional = this.reader.getMark();
        int n = this.reader.peek();
        this.reader.forward();
        stringBuilder.append(this.scanFlowScalarNonSpaces(bl, optional));
        while (this.reader.peek() != n) {
            stringBuilder.append(this.scanFlowScalarSpaces(optional));
            stringBuilder.append(this.scanFlowScalarNonSpaces(bl, optional));
        }
        this.reader.forward();
        Optional<Mark> optional2 = this.reader.getMark();
        return new ScalarToken(stringBuilder.toString(), false, scalarStyle, optional, optional2);
    }

    private String scanFlowScalarNonSpaces(boolean bl, Optional<Mark> optional) {
        StringBuilder stringBuilder;
        block10: {
            String string;
            int n;
            stringBuilder = new StringBuilder();
            while (true) {
                int n2 = 0;
                while (CharConstants.NULL_BL_T_LINEBR.hasNo(this.reader.peek(n2), "'\"\\")) {
                    ++n2;
                }
                if (n2 != 0) {
                    stringBuilder.append(this.reader.prefixForward(n2));
                }
                n = this.reader.peek();
                if (!bl && n == 39 && this.reader.peek(1) == 39) {
                    stringBuilder.append("'");
                    this.reader.forward(2);
                    continue;
                }
                if (bl && n == 39 || !bl && "\"\\".indexOf(n) != -1) {
                    stringBuilder.appendCodePoint(n);
                    this.reader.forward();
                    continue;
                }
                if (!bl || n != 92) break block10;
                this.reader.forward();
                n = this.reader.peek();
                if (!Character.isSupplementaryCodePoint(n) && CharConstants.ESCAPE_REPLACEMENTS.containsKey(Character.valueOf((char)n))) {
                    stringBuilder.append(CharConstants.ESCAPE_REPLACEMENTS.get(Character.valueOf((char)n)));
                    this.reader.forward();
                    continue;
                }
                if (!Character.isSupplementaryCodePoint(n) && CharConstants.ESCAPE_CODES.containsKey(Character.valueOf((char)n))) {
                    n2 = CharConstants.ESCAPE_CODES.get(Character.valueOf((char)n));
                    this.reader.forward();
                    string = this.reader.prefix(n2);
                    if (NOT_HEXA.matcher(string).find()) {
                        throw new ScannerException("while scanning a double-quoted scalar", optional, "expected escape sequence of " + n2 + " hexadecimal numbers, but found: " + string, this.reader.getMark());
                    }
                    int n3 = Integer.parseInt(string, 16);
                    try {
                        String string2 = new String(Character.toChars(n3));
                        stringBuilder.append(string2);
                        this.reader.forward(n2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ScannerException("while scanning a double-quoted scalar", optional, "found unknown escape character " + string, this.reader.getMark());
                    }
                }
                if (!this.scanLineBreak().isPresent()) break;
                stringBuilder.append(this.scanFlowScalarBreaks(optional));
            }
            string = String.valueOf(Character.toChars(n));
            throw new ScannerException("while scanning a double-quoted scalar", optional, "found unknown escape character " + string + "(" + n + ")", this.reader.getMark());
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarSpaces(Optional<Mark> optional) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (" \t".indexOf(this.reader.peek(n)) != -1) {
            ++n;
        }
        String string = this.reader.prefixForward(n);
        int n2 = this.reader.peek();
        if (n2 == 0) {
            throw new ScannerException("while scanning a quoted scalar", optional, "found unexpected end of stream", this.reader.getMark());
        }
        Optional<String> optional2 = this.scanLineBreak();
        if (optional2.isPresent()) {
            String string2 = this.scanFlowScalarBreaks(optional);
            if (!"\n".equals(optional2.get())) {
                stringBuilder.append(optional2.get());
            } else if (string2.isEmpty()) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2);
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String scanFlowScalarBreaks(Optional<Mark> optional) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            String string;
            if (("---".equals(string = this.reader.prefix(3)) || "...".equals(string)) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                throw new ScannerException("while scanning a quoted scalar", optional, "found unexpected document separator", this.reader.getMark());
            }
            while (" \t".indexOf(this.reader.peek()) != -1) {
                this.reader.forward();
            }
            Optional<String> optional2 = this.scanLineBreak();
            if (!optional2.isPresent()) break;
            stringBuilder.append(optional2.get());
        }
        return stringBuilder.toString();
    }

    private Token scanPlain() {
        Optional<Mark> optional;
        StringBuilder stringBuilder = new StringBuilder();
        Optional<Mark> optional2 = optional = this.reader.getMark();
        int n = this.indent + 1;
        String string = "";
        do {
            int n2;
            int n3 = 0;
            if (this.reader.peek() == 35) break;
            while (!(CharConstants.NULL_BL_T_LINEBR.has(n2 = this.reader.peek(n3)) || n2 == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(n3 + 1), this.isFlowContext() ? ",[]{}" : "") || this.isFlowContext() && ",[]{}".indexOf(n2) != -1)) {
                ++n3;
            }
            if (n3 == 0) break;
            this.allowSimpleKey = false;
            stringBuilder.append(string);
            stringBuilder.append(this.reader.prefixForward(n3));
            optional2 = this.reader.getMark();
        } while (!(string = this.scanPlainSpaces()).isEmpty() && this.reader.peek() != 35 && (!this.isBlockContext() || this.reader.getColumn() >= n));
        return new ScalarToken(stringBuilder.toString(), true, optional, optional2);
    }

    private boolean atEndOfPlain() {
        int n;
        int n2 = 0;
        int n3 = this.reader.getColumn();
        while ((n = this.reader.peek(n2)) != 0 && CharConstants.NULL_BL_T_LINEBR.has(n)) {
            if (!(CharConstants.LINEBR.has(n) || n == 13 && this.reader.peek(++n2 + 1) == 10 || n == 65279)) {
                ++n3;
                continue;
            }
            n3 = 0;
        }
        if (this.reader.peek(n2) == 35 || this.reader.peek(n2 + 1) == 0 || this.isBlockContext() && n3 < this.indent) {
            return true;
        }
        if (this.isBlockContext()) {
            int n4 = 1;
            while ((n = this.reader.peek(n2 + n4)) != 0 && !CharConstants.NULL_BL_T_LINEBR.has(n)) {
                if (n == 58 && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(n2 + n4 + 1))) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    private String scanPlainSpaces() {
        int n = 0;
        while (this.reader.peek(n) == 32 || this.reader.peek(n) == 9) {
            ++n;
        }
        String string = this.reader.prefixForward(n);
        Optional<String> optional = this.scanLineBreak();
        if (optional.isPresent()) {
            StringBuilder stringBuilder;
            block8: {
                this.allowSimpleKey = true;
                String string2 = this.reader.prefix(3);
                if ("---".equals(string2) || "...".equals(string2) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) {
                    return "";
                }
                if (this.settings.getParseComments() && this.atEndOfPlain()) {
                    return "";
                }
                stringBuilder = new StringBuilder();
                while (true) {
                    if (this.reader.peek() == 32) {
                        this.reader.forward();
                        continue;
                    }
                    Optional<String> optional2 = this.scanLineBreak();
                    if (!optional2.isPresent()) break block8;
                    stringBuilder.append(optional2.get());
                    string2 = this.reader.prefix(3);
                    if ("---".equals(string2) || "...".equals(string2) && CharConstants.NULL_BL_T_LINEBR.has(this.reader.peek(3))) break;
                }
                return "";
            }
            if (!"\n".equals(optional.orElse(""))) {
                return optional.orElse("") + stringBuilder;
            }
            if (stringBuilder.length() == 0) {
                return " ";
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private String scanTagHandle(String string, Optional<Mark> optional) {
        int n = this.reader.peek();
        if (n != 33) {
            String string2 = String.valueOf(Character.toChars(n));
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected '!', but found " + string2 + "(" + n + ")", this.reader.getMark());
        }
        int n2 = 1;
        n = this.reader.peek(n2);
        if (n != 32) {
            while (CharConstants.ALPHA.has(n)) {
                n = this.reader.peek(++n2);
            }
            if (n != 33) {
                this.reader.forward(n2);
                String string3 = String.valueOf(Character.toChars(n));
                throw new ScannerException(SCANNING_PREFIX + string, optional, "expected '!', but found " + string3 + "(" + n + ")", this.reader.getMark());
            }
            ++n2;
        }
        return this.reader.prefixForward(n2);
    }

    private String scanTagUri(String string, CharConstants charConstants, Optional<Mark> optional) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = this.reader.peek(n);
        while (charConstants.has(n2)) {
            if (n2 == 37) {
                stringBuilder.append(this.reader.prefixForward(n));
                n = 0;
                stringBuilder.append(this.scanUriEscapes(string, optional));
            } else {
                ++n;
            }
            n2 = this.reader.peek(n);
        }
        if (n != 0) {
            stringBuilder.append(this.reader.prefixForward(n));
        }
        if (stringBuilder.length() == 0) {
            String string2 = String.valueOf(Character.toChars(n2));
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI, but found " + string2 + "(" + n2 + ")", this.reader.getMark());
        }
        return stringBuilder.toString();
    }

    private String scanUriEscapes(String string, Optional<Mark> optional) {
        int n = 1;
        while (this.reader.peek(n * 3) == 37) {
            ++n;
        }
        Optional<Mark> optional2 = this.reader.getMark();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        while (this.reader.peek() == 37) {
            this.reader.forward();
            try {
                byte by = (byte)Integer.parseInt(this.reader.prefix(2), 16);
                byteBuffer.put(by);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = this.reader.peek();
                String string2 = String.valueOf(Character.toChars(n2));
                int n3 = this.reader.peek(1);
                String string3 = String.valueOf(Character.toChars(n3));
                throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI escape sequence of 2 hexadecimal numbers, but found " + string2 + "(" + n2 + ") and " + string3 + "(" + n3 + ")", this.reader.getMark());
            }
            this.reader.forward(2);
        }
        byteBuffer.flip();
        try {
            return UriEncoder.decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new ScannerException(SCANNING_PREFIX + string, optional, "expected URI in UTF-8: " + characterCodingException.getMessage(), optional2);
        }
    }

    private Optional<String> scanLineBreak() {
        int n = this.reader.peek();
        if (n == 13 || n == 10 || n == 133) {
            if (n == 13 && 10 == this.reader.peek(1)) {
                this.reader.forward(2);
            } else {
                this.reader.forward();
            }
            return Optional.of("\n");
        }
        return Optional.empty();
    }

    private List<Token> makeTokenList(Token ... tokenArray) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (int i = 0; i < tokenArray.length; ++i) {
            if (tokenArray[i] == null || !this.settings.getParseComments() && tokenArray[i] instanceof CommentToken) continue;
            arrayList.add(tokenArray[i]);
        }
        return arrayList;
    }

    @Override
    public void resetDocumentIndex() {
        this.reader.resetDocumentIndex();
    }

    static class Chomping {
        private final Indicator value;
        private final Optional<Integer> increment;

        public Chomping(Indicator indicator, Optional<Integer> optional) {
            this.value = indicator;
            this.increment = optional;
        }

        public Chomping(int n, Optional<Integer> optional) {
            this(Chomping.parse(n), optional);
        }

        private static Indicator parse(int n) {
            if (n == 43) {
                return Indicator.KEEP;
            }
            if (n == 45) {
                return Indicator.STRIP;
            }
            if (n == Integer.MIN_VALUE) {
                return Indicator.CLIP;
            }
            throw new IllegalArgumentException("Unexpected block chomping indicator: " + n);
        }

        static enum Indicator {
            STRIP,
            CLIP,
            KEEP;

        }
    }

    static class BreakIntentHolder {
        private final String breaks;
        private final int maxIndent;
        private final Optional<Mark> endMark;

        public BreakIntentHolder(String string, int n, Optional<Mark> optional) {
            this.breaks = string;
            this.maxIndent = n;
            this.endMark = optional;
        }
    }
}

