/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.scanner;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Optional;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.CharConstants;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.ReaderException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;

public final class StreamReader {
    private final String name;
    private final Reader stream;
    private final int bufferSize;
    private final char[] buffer;
    private final boolean useMarks;
    private int[] codePointsWindow;
    private int dataLength;
    private int pointer = 0;
    private boolean eof;
    private int index = 0;
    private int documentIndex = 0;
    private int line = 0;
    private int column = 0;

    @Deprecated
    public StreamReader(Reader reader, LoadSettings loadSettings) {
        this(loadSettings, reader);
    }

    public StreamReader(LoadSettings loadSettings, Reader reader) {
        this.name = loadSettings.getLabel();
        this.codePointsWindow = new int[0];
        this.dataLength = 0;
        this.stream = reader;
        this.eof = false;
        this.bufferSize = loadSettings.getBufferSize();
        this.buffer = new char[this.bufferSize];
        this.useMarks = loadSettings.getUseMarks();
    }

    @Deprecated
    public StreamReader(String string, LoadSettings loadSettings) {
        this(loadSettings, new StringReader(string));
    }

    public StreamReader(LoadSettings loadSettings, String string) {
        this(loadSettings, new StringReader(string));
    }

    public static boolean isPrintable(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (StreamReader.isPrintable(n)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int n) {
        return n >= 32 && n <= 126 || n == 9 || n == 10 || n == 13 || n == 133 || n >= 160 && n <= 55295 || n >= 57344 && n <= 65533 || n >= 65536 && n <= 0x10FFFF;
    }

    public Optional<Mark> getMark() {
        if (this.useMarks) {
            return Optional.of(new Mark(this.name, this.index, this.line, this.column, this.codePointsWindow, this.pointer));
        }
        return Optional.empty();
    }

    public void forward() {
        this.forward(1);
    }

    public void forward(int n) {
        for (int i = 0; i < n && this.ensureEnoughData(); ++i) {
            int n2 = this.codePointsWindow[this.pointer++];
            this.moveIndices(1);
            if (CharConstants.LINEBR.has(n2) || n2 == 13 && this.ensureEnoughData() && this.codePointsWindow[this.pointer] != 10) {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (n2 == 65279) continue;
            ++this.column;
        }
    }

    public int peek() {
        return this.ensureEnoughData() ? this.codePointsWindow[this.pointer] : 0;
    }

    public int peek(int n) {
        return this.ensureEnoughData(n) ? this.codePointsWindow[this.pointer + n] : 0;
    }

    public String prefix(int n) {
        if (n == 0) {
            return "";
        }
        if (this.ensureEnoughData(n)) {
            return new String(this.codePointsWindow, this.pointer, n);
        }
        return new String(this.codePointsWindow, this.pointer, Math.min(n, this.dataLength - this.pointer));
    }

    public String prefixForward(int n) {
        String string = this.prefix(n);
        this.pointer += n;
        this.moveIndices(n);
        this.column += n;
        return string;
    }

    private boolean ensureEnoughData() {
        return this.ensureEnoughData(0);
    }

    private boolean ensureEnoughData(int n) {
        if (!this.eof && this.pointer + n >= this.dataLength) {
            this.update();
        }
        return this.pointer + n < this.dataLength;
    }

    private void update() {
        try {
            int n = this.stream.read(this.buffer, 0, this.bufferSize);
            if (n > 0) {
                int n2 = this.dataLength - this.pointer;
                this.codePointsWindow = Arrays.copyOfRange(this.codePointsWindow, this.pointer, this.dataLength + n);
                if (Character.isHighSurrogate(this.buffer[n - 1])) {
                    if (this.stream.read(this.buffer, n, 1) == -1) {
                        this.eof = true;
                    } else {
                        ++n;
                    }
                }
                Optional<Object> optional = Optional.empty();
                int n3 = 0;
                while (n3 < n) {
                    int n4;
                    this.codePointsWindow[n2] = n4 = Character.codePointAt(this.buffer, n3);
                    if (StreamReader.isPrintable(n4)) {
                        n3 += Character.charCount(n4);
                    } else {
                        optional = Optional.of(n4);
                        n3 = n;
                    }
                    ++n2;
                }
                this.dataLength = n2;
                this.pointer = 0;
                if (optional.isPresent()) {
                    throw new ReaderException(this.name, n2 - 1, (Integer)optional.get(), "special characters are not allowed");
                }
            } else {
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            throw new YamlEngineException(iOException);
        }
    }

    public int getColumn() {
        return this.column;
    }

    private void moveIndices(int n) {
        this.index += n;
        this.documentIndex += n;
    }

    public int getDocumentIndex() {
        return this.documentIndex;
    }

    public void resetDocumentIndex() {
        this.documentIndex = 0;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLine() {
        return this.line;
    }
}

