/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.Anchor;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.emitter.Emitable;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.CommentEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.DocumentEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.DocumentStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.ImplicitTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.MappingEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.SequenceEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.StreamEndEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.events.StreamStartEvent;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.AnchorNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;

public class Serializer {
    private final DumpSettings settings;
    private final Emitable emitable;
    private final Set<Node> serializedNodes;
    private final Map<Node, Anchor> anchors;
    private final boolean dereferenceAliases;
    private final Set<Node> recursive;

    public Serializer(DumpSettings dumpSettings, Emitable emitable) {
        this.settings = dumpSettings;
        this.emitable = emitable;
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, Anchor>();
        this.dereferenceAliases = dumpSettings.isDereferenceAliases();
        this.recursive = Collections.newSetFromMap(new IdentityHashMap());
    }

    public void serializeDocument(Node node) {
        this.emitable.emit(new DocumentStartEvent(this.settings.isExplicitStart(), this.settings.getYamlDirective(), this.settings.getTagDirective()));
        this.anchorNode(node);
        this.settings.getExplicitRootTag().ifPresent(node::setTag);
        this.serializeNode(node);
        this.emitable.emit(new DocumentEndEvent(this.settings.isExplicitEnd()));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.recursive.clear();
    }

    public void emitStreamStart() {
        this.emitable.emit(new StreamStartEvent());
    }

    public void emitStreamEnd() {
        this.emitable.emit(new StreamEndEvent());
    }

    private void anchorNode(Node node) {
        Node node3 = node.getNodeType() == NodeType.ANCHOR ? ((AnchorNode)node).getRealNode() : node;
        if (this.anchors.containsKey(node3)) {
            this.anchors.computeIfAbsent(node3, node2 -> this.settings.getAnchorGenerator().nextAnchor(node3));
        } else {
            this.anchors.put(node3, node3.getAnchor().isPresent() ? this.settings.getAnchorGenerator().nextAnchor(node3) : null);
            switch (node3.getNodeType()) {
                case SEQUENCE: {
                    SequenceNode sequenceNode = (SequenceNode)node3;
                    List<Node> list = sequenceNode.getValue();
                    for (Node node4 : list) {
                        this.anchorNode(node4);
                    }
                    break;
                }
                case MAPPING: {
                    MappingNode mappingNode = (MappingNode)node3;
                    List<NodeTuple> list = mappingNode.getValue();
                    for (NodeTuple nodeTuple : list) {
                        Node node5 = nodeTuple.getKeyNode();
                        Node node6 = nodeTuple.getValueNode();
                        this.anchorNode(node5);
                        this.anchorNode(node6);
                    }
                    break;
                }
            }
        }
    }

    private void serializeNode(Node node) {
        if (node.getNodeType() == NodeType.ANCHOR) {
            node = ((AnchorNode)node).getRealNode();
        }
        if (this.dereferenceAliases && this.recursive.contains(node)) {
            throw new YamlEngineException("Cannot dereferenceAliases for recursive structures.");
        }
        this.recursive.add(node);
        Optional<Anchor> optional = !this.dereferenceAliases ? Optional.ofNullable(this.anchors.get(node)) : Optional.empty();
        if (!this.dereferenceAliases && this.serializedNodes.contains(node)) {
            this.emitable.emit(new AliasEvent(optional));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeType()) {
                case SCALAR: {
                    ScalarNode scalarNode = (ScalarNode)node;
                    this.serializeComments(node.getBlockComments());
                    Tag tag = this.settings.getSchema().getScalarResolver().resolve(scalarNode.getValue(), true);
                    Tag tag2 = this.settings.getSchema().getScalarResolver().resolve(scalarNode.getValue(), false);
                    ImplicitTuple implicitTuple = new ImplicitTuple(node.getTag().equals(tag), node.getTag().equals(tag2));
                    ScalarEvent scalarEvent = new ScalarEvent(optional, Optional.of(node.getTag().getValue()), implicitTuple, scalarNode.getValue(), scalarNode.getScalarStyle());
                    this.emitable.emit(scalarEvent);
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                    break;
                }
                case SEQUENCE: {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    this.serializeComments(node.getBlockComments());
                    boolean bl = node.getTag().equals(Tag.SEQ);
                    this.emitable.emit(new SequenceStartEvent(optional, Optional.of(node.getTag().getValue()), bl, sequenceNode.getFlowStyle()));
                    List<Node> list = sequenceNode.getValue();
                    for (Node node2 : list) {
                        this.serializeNode(node2);
                    }
                    this.emitable.emit(new SequenceEndEvent());
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                    break;
                }
                default: {
                    this.serializeComments(node.getBlockComments());
                    boolean bl = node.getTag().equals(Tag.MAP);
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> list = mappingNode.getValue();
                    if (mappingNode.getTag() == Tag.COMMENT) break;
                    this.emitable.emit(new MappingStartEvent(optional, Optional.of(mappingNode.getTag().getValue()), bl, mappingNode.getFlowStyle(), Optional.empty(), Optional.empty()));
                    for (NodeTuple nodeTuple : list) {
                        Node node3 = nodeTuple.getKeyNode();
                        Node node4 = nodeTuple.getValueNode();
                        this.serializeNode(node3);
                        this.serializeNode(node4);
                    }
                    this.emitable.emit(new MappingEndEvent());
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                }
            }
        }
        this.recursive.remove(node);
    }

    private void serializeComments(List<CommentLine> list) {
        if (list == null) {
            return;
        }
        for (CommentLine commentLine : list) {
            CommentEvent commentEvent = new CommentEvent(commentLine.getCommentType(), commentLine.getValue(), commentLine.getStartMark(), commentLine.getEndMark());
            this.emitable.emit(commentEvent);
        }
    }
}

