/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.route;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.route.RouteFactory;
import xshyo.us.theglow.libs.config.route.implementation.MultiKeyRoute;
import xshyo.us.theglow.libs.config.route.implementation.SingleKeyRoute;

public interface Route {
    @NotNull
    public static Route from(Object ... objectArray) {
        if (Objects.requireNonNull(objectArray, "Route array cannot be null!").length == 0) {
            throw new IllegalArgumentException("Empty routes are not allowed!");
        }
        return objectArray.length == 1 ? new SingleKeyRoute(objectArray[0]) : new MultiKeyRoute(objectArray);
    }

    @NotNull
    public static Route from(@NotNull Object object) {
        return new SingleKeyRoute(object);
    }

    @NotNull
    public static Route fromSingleKey(@NotNull Object object) {
        return new SingleKeyRoute(object);
    }

    @NotNull
    public static Route fromString(@NotNull String string) {
        return Route.fromString(string, '.');
    }

    @NotNull
    public static Route fromString(@NotNull String string, char c) {
        return string.indexOf(c) != -1 ? new MultiKeyRoute(string.split(Pattern.quote(String.valueOf(c)))) : new SingleKeyRoute(string);
    }

    @NotNull
    public static Route fromString(@NotNull String string, @NotNull RouteFactory routeFactory) {
        return string.indexOf(routeFactory.getSeparator()) != -1 ? new MultiKeyRoute(string.split(routeFactory.getEscapedSeparator())) : new SingleKeyRoute(string);
    }

    @NotNull
    public static Route addTo(@Nullable Route route, @NotNull Object object) {
        return route == null ? Route.fromSingleKey(object) : route.add(object);
    }

    @NotNull
    public String join(char var1);

    public int length();

    @NotNull
    public Object get(int var1);

    @NotNull
    public Route add(@NotNull Object var1);

    @NotNull
    public Route parent();

    public boolean equals(Object var1);

    public int hashCode();
}

