/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.route;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.config.route.Route;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;

public class RouteFactory {
    private final char separator;
    private final String escapedSeparator;

    public RouteFactory(@NotNull GeneralSettings generalSettings) {
        this.separator = generalSettings.getRouteSeparator();
        this.escapedSeparator = generalSettings.getEscapedSeparator();
    }

    public RouteFactory(char c) {
        this.separator = c;
        this.escapedSeparator = Pattern.quote(String.valueOf(c));
    }

    public RouteFactory() {
        this.separator = (char)46;
        this.escapedSeparator = GeneralSettings.DEFAULT_ESCAPED_SEPARATOR;
    }

    @NotNull
    public Route create(String string) {
        return Route.fromString(string, this);
    }

    public char getSeparator() {
        return this.separator;
    }

    @NotNull
    public String getEscapedSeparator() {
        return this.escapedSeparator;
    }
}

