/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.route.implementation;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.config.route.Route;

public class MultiKeyRoute
implements Route {
    private final Object[] route;

    public MultiKeyRoute(Object ... objectArray) {
        if (Objects.requireNonNull(objectArray, "Route array cannot be null!").length == 0) {
            throw new IllegalArgumentException("Empty routes are not allowed!");
        }
        for (Object object : objectArray) {
            Objects.requireNonNull(object, "Route cannot contain null keys!");
        }
        this.route = objectArray;
    }

    @Override
    @NotNull
    public String join(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.length(); ++i) {
            stringBuilder.append(this.get(i)).append(i + 1 < this.length() ? Character.valueOf(c) : "");
        }
        return stringBuilder.toString();
    }

    @Override
    public int length() {
        return this.route.length;
    }

    @Override
    @NotNull
    public Object get(int n) {
        return this.route[n];
    }

    @Override
    @NotNull
    public Route add(@NotNull Object object) {
        Object[] objectArray = Arrays.copyOf(this.route, this.route.length + 1);
        objectArray[objectArray.length - 1] = Objects.requireNonNull(object, "Route cannot contain null keys!");
        return new MultiKeyRoute(objectArray);
    }

    @Override
    @NotNull
    public Route parent() {
        return this.route.length == 2 ? Route.from(this.route[0]) : Route.from(Arrays.copyOf(this.route, this.route.length - 1));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Route)) {
            return false;
        }
        Route route = (Route)object;
        if (this.length() != route.length()) {
            return false;
        }
        if (this.length() == 1 && route.length() == 1) {
            return Objects.equals(this.get(0), route.get(0));
        }
        if (!(route instanceof MultiKeyRoute)) {
            return false;
        }
        return Arrays.equals(this.route, ((MultiKeyRoute)route).route);
    }

    @Override
    public int hashCode() {
        return this.length() > 1 ? Arrays.hashCode(this.route) : Objects.hashCode(this.route[0]);
    }

    public String toString() {
        return "MultiKeyRoute{route=" + Arrays.toString(this.route) + '}';
    }
}

