/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.serialization.standard;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.serialization.YamlSerializer;
import xshyo.us.theglow.libs.config.serialization.standard.TypeAdapter;
import xshyo.us.theglow.libs.config.utils.supplier.MapSupplier;

public class StandardSerializer
implements YamlSerializer {
    public static final String DEFAULT_SERIALIZED_TYPE_KEY = "==";
    private static final StandardSerializer defaultSerializer = new StandardSerializer("==");
    private final Map<Class<?>, TypeAdapter<?>> adapters = new HashMap();
    private final Map<String, Class<?>> aliases = new HashMap();
    private final Object serializedTypeKey;

    public StandardSerializer(@NotNull Object object) {
        this.serializedTypeKey = object;
    }

    public <T> void register(@NotNull Class<T> clazz, @NotNull TypeAdapter<T> typeAdapter) {
        this.adapters.put(clazz, typeAdapter);
        this.aliases.put(clazz.getCanonicalName(), clazz);
    }

    public <T> void register(@NotNull String string, @NotNull Class<T> clazz) {
        if (!this.adapters.containsKey(clazz)) {
            throw new IllegalStateException("Cannot register an alias for yet unregistered type!");
        }
        this.aliases.put(string, clazz);
    }

    @Override
    @Nullable
    public Object deserialize(@NotNull Map<Object, Object> map) {
        if (!map.containsKey(this.serializedTypeKey)) {
            return null;
        }
        Class<?> clazz = this.aliases.get(map.get(this.serializedTypeKey).toString());
        if (clazz == null) {
            return null;
        }
        return this.adapters.get(clazz).deserialize(map);
    }

    @Override
    @Nullable
    public <T> Map<Object, Object> serialize(@NotNull T t, @NotNull MapSupplier mapSupplier) {
        if (!this.adapters.containsKey(t.getClass())) {
            return null;
        }
        Map<Object, Object> map = mapSupplier.supply(1);
        map.putAll(this.adapters.get(t.getClass()).serialize(t));
        map.computeIfAbsent(this.serializedTypeKey, object2 -> t.getClass().getCanonicalName());
        return map;
    }

    @Override
    @NotNull
    public Set<Class<?>> getSupportedClasses() {
        return this.adapters.keySet();
    }

    @Override
    @NotNull
    public Set<Class<?>> getSupportedParentClasses() {
        return Collections.emptySet();
    }

    public static StandardSerializer getDefault() {
        return defaultSerializer;
    }
}

