/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.settings.dumper;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.DumpSettingsBuilder;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.SpecVersion;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.Schema;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer.AnchorGenerator;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.serializer.NumberAnchorGenerator;
import xshyo.us.theglow.libs.config.settings.Settings;
import xshyo.us.theglow.libs.config.utils.format.Formatter;

public class DumperSettings
implements Settings {
    public static final DumperSettings DEFAULT = DumperSettings.builder().build();
    private final DumpSettingsBuilder builder;
    private final Supplier<AnchorGenerator> generatorSupplier;
    private final ScalarStyle stringStyle;
    private final Formatter<ScalarStyle, String> scalarFormatter;
    private final Formatter<FlowStyle, Iterable<?>> sequenceFormatter;
    private final Formatter<FlowStyle, Map<?, ?>> mappingFormatter;

    private DumperSettings(Builder builder) {
        this.builder = builder.builder;
        this.generatorSupplier = builder.anchorGeneratorSupplier;
        this.scalarFormatter = builder.scalarFormatter;
        this.sequenceFormatter = builder.sequenceFormatter;
        this.mappingFormatter = builder.mappingFormatter;
        this.stringStyle = builder.stringStyle;
    }

    public DumpSettings buildEngineSettings() {
        return this.builder.setAnchorGenerator(this.generatorSupplier.get()).setDumpComments(true).build();
    }

    public ScalarStyle getStringStyle() {
        return this.stringStyle;
    }

    public Formatter<ScalarStyle, String> getScalarFormatter() {
        return this.scalarFormatter;
    }

    public Formatter<FlowStyle, Iterable<?>> getSequenceFormatter() {
        return this.sequenceFormatter;
    }

    public Formatter<FlowStyle, Map<?, ?>> getMappingFormatter() {
        return this.mappingFormatter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DumpSettingsBuilder dumpSettingsBuilder) {
        return new Builder(dumpSettingsBuilder);
    }

    public static Builder builder(DumperSettings dumperSettings) {
        return DumperSettings.builder(dumperSettings.builder).setAnchorGenerator(dumperSettings.generatorSupplier);
    }

    public static class Builder {
        public static final Supplier<AnchorGenerator> DEFAULT_ANCHOR_GENERATOR = () -> new NumberAnchorGenerator(0);
        public static final FlowStyle DEFAULT_FLOW_STYLE = FlowStyle.BLOCK;
        public static final ScalarStyle DEFAULT_SCALAR_STYLE = ScalarStyle.PLAIN;
        public static final Formatter<ScalarStyle, String> DEFAULT_SCALAR_FORMATTER = Formatter.identity();
        public static final Formatter<FlowStyle, Iterable<?>> DEFAULT_SEQUENCE_FORMATTER = Formatter.identity();
        public static final Formatter<FlowStyle, Map<?, ?>> DEFAULT_MAPPING_FORMATTER = Formatter.identity();
        public static final ScalarStyle DEFAULT_STRING_STYLE = ScalarStyle.PLAIN;
        public static final boolean DEFAULT_START_MARKER = false;
        public static final boolean DEFAULT_END_MARKER = false;
        public static final Tag DEFAULT_ROOT_TAG = null;
        public static final boolean DEFAULT_CANONICAL = false;
        public static final boolean DEFAULT_MULTILINE_FORMAT = false;
        public static final Encoding DEFAULT_ENCODING = Encoding.UNICODE;
        public static final int DEFAULT_INDENTATION = 2;
        public static final int DEFAULT_INDICATOR_INDENTATION = 0;
        public static final int DEFAULT_MAX_LINE_WIDTH = 0;
        public static final int DEFAULT_MAX_SIMPLE_KEY_LENGTH = 0;
        public static final boolean DEFAULT_ESCAPE_UNPRINTABLE = true;
        private final DumpSettingsBuilder builder;
        private Supplier<AnchorGenerator> anchorGeneratorSupplier = DEFAULT_ANCHOR_GENERATOR;
        private Formatter<ScalarStyle, String> scalarFormatter = DEFAULT_SCALAR_FORMATTER;
        private Formatter<FlowStyle, Iterable<?>> sequenceFormatter = DEFAULT_SEQUENCE_FORMATTER;
        private Formatter<FlowStyle, Map<?, ?>> mappingFormatter = DEFAULT_MAPPING_FORMATTER;
        private ScalarStyle stringStyle = DEFAULT_STRING_STYLE;

        private Builder(DumpSettingsBuilder dumpSettingsBuilder) {
            this.builder = dumpSettingsBuilder;
        }

        private Builder() {
            this.builder = DumpSettings.builder();
            this.setFlowStyle(DEFAULT_FLOW_STYLE);
            this.setScalarStyle(DEFAULT_SCALAR_STYLE);
            this.setStringStyle(DEFAULT_STRING_STYLE);
            this.setStartMarker(false);
            this.setEndMarker(false);
            this.setRootTag(DEFAULT_ROOT_TAG);
            this.setCanonicalForm(false);
            this.setMultilineStyle(false);
            this.setEncoding(DEFAULT_ENCODING);
            this.setIndentation(2);
            this.setIndicatorIndentation(0);
            this.setLineWidth(0);
            this.setMaxSimpleKeyLength(0);
            this.setEscapeUnprintable(true);
        }

        public Builder setAnchorGenerator(@NotNull Supplier<AnchorGenerator> supplier) {
            this.anchorGeneratorSupplier = supplier;
            return this;
        }

        public Builder setFlowStyle(@NotNull FlowStyle flowStyle) {
            this.builder.setDefaultFlowStyle(flowStyle);
            return this;
        }

        public Builder setScalarStyle(@NotNull ScalarStyle scalarStyle) {
            this.builder.setDefaultScalarStyle(scalarStyle);
            return this;
        }

        public Builder setScalarFormatter(@NotNull Formatter<ScalarStyle, String> formatter) {
            this.scalarFormatter = formatter;
            return this;
        }

        public Builder setSequenceFormatter(@NotNull Formatter<FlowStyle, Iterable<?>> formatter) {
            this.sequenceFormatter = formatter;
            return this;
        }

        public Builder setMappingFormatter(@NotNull Formatter<FlowStyle, Map<?, ?>> formatter) {
            this.mappingFormatter = formatter;
            return this;
        }

        @Deprecated
        public Builder setStringStyle(@NotNull ScalarStyle scalarStyle) {
            this.stringStyle = scalarStyle;
            return this;
        }

        public Builder setStartMarker(boolean bl) {
            this.builder.setExplicitStart(bl);
            return this;
        }

        public Builder setEndMarker(boolean bl) {
            this.builder.setExplicitEnd(bl);
            return this;
        }

        public Builder setSchema(@NotNull Schema schema) {
            this.builder.setSchema(schema);
            return this;
        }

        public Builder setRootTag(@Nullable Tag tag) {
            this.builder.setExplicitRootTag(Optional.ofNullable(tag));
            return this;
        }

        public Builder setYamlDirective(@Nullable SpecVersion specVersion) {
            this.builder.setYamlDirective(Optional.ofNullable(specVersion));
            return this;
        }

        public Builder setTagDirectives(@NotNull Map<String, String> map) {
            this.builder.setTagDirective(map);
            return this;
        }

        public Builder setCanonicalForm(boolean bl) {
            this.builder.setCanonical(bl);
            return this;
        }

        public Builder setMultilineStyle(boolean bl) {
            this.builder.setMultiLineFlow(bl);
            return this;
        }

        public Builder setEncoding(@NotNull Encoding encoding) {
            this.builder.setUseUnicodeEncoding(encoding.isUnicode());
            return this;
        }

        public Builder setIndentation(int n) {
            this.builder.setIndent(n);
            return this;
        }

        public Builder setIndicatorIndentation(int n) {
            this.builder.setIndentWithIndicator(n > 0);
            this.builder.setIndicatorIndent(Math.max(n, 0));
            return this;
        }

        public Builder setLineWidth(int n) {
            this.builder.setWidth(n <= 0 ? Integer.MAX_VALUE : n);
            return this;
        }

        public Builder setLineBreak(@NotNull String string) {
            this.builder.setBestLineBreak(string);
            return this;
        }

        public Builder setMaxSimpleKeyLength(int n) {
            if (n > 1018) {
                throw new IllegalArgumentException("Maximum simple key length is limited to 1018!");
            }
            this.builder.setMaxSimpleKeyLength(n <= 0 ? 1024 : n + 6);
            return this;
        }

        public Builder setEscapeUnprintable(boolean bl) {
            return this.setUnprintableStyle(bl ? NonPrintableStyle.ESCAPE : NonPrintableStyle.BINARY);
        }

        public Builder setUnprintableStyle(@NotNull NonPrintableStyle nonPrintableStyle) {
            this.builder.setNonPrintableStyle(nonPrintableStyle);
            return this;
        }

        public DumperSettings build() {
            return new DumperSettings(this);
        }
    }

    public static enum Encoding {
        UNICODE,
        ASCII;


        boolean isUnicode() {
            return this == UNICODE;
        }
    }
}

