/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.settings.loader;

import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.api.LoadSettingsBuilder;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.env.EnvConfig;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.schema.Schema;
import xshyo.us.theglow.libs.config.settings.Settings;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;

public class LoaderSettings
implements Settings {
    public static final LoaderSettings DEFAULT = LoaderSettings.builder().build();
    private final LoadSettingsBuilder builder;
    private final boolean createFileIfAbsent;
    private final boolean autoUpdate;

    private LoaderSettings(Builder builder) {
        this.builder = builder.builder;
        this.autoUpdate = builder.autoUpdate;
        this.createFileIfAbsent = builder.createFileIfAbsent;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isCreateFileIfAbsent() {
        return this.createFileIfAbsent;
    }

    public LoadSettings buildEngineSettings(GeneralSettings generalSettings) {
        return this.builder.setParseComments(true).setDefaultList(generalSettings::getDefaultList).setDefaultSet(generalSettings::getDefaultSet).setDefaultMap(generalSettings::getDefaultMap).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadSettingsBuilder loadSettingsBuilder) {
        return new Builder(loadSettingsBuilder);
    }

    public static Builder builder(LoaderSettings loaderSettings) {
        return LoaderSettings.builder(loaderSettings.builder).setAutoUpdate(loaderSettings.autoUpdate).setCreateFileIfAbsent(loaderSettings.createFileIfAbsent);
    }

    public static class Builder {
        public static final boolean DEFAULT_CREATE_FILE_IF_ABSENT = true;
        public static final boolean DEFAULT_AUTO_UPDATE = false;
        public static final boolean DEFAULT_DETAILED_ERRORS = true;
        public static final boolean DEFAULT_ALLOW_DUPLICATE_KEYS = true;
        private final LoadSettingsBuilder builder;
        private boolean autoUpdate = false;
        private boolean createFileIfAbsent = true;

        private Builder(LoadSettingsBuilder loadSettingsBuilder) {
            this.builder = loadSettingsBuilder;
        }

        private Builder() {
            this.builder = LoadSettings.builder();
            this.setDetailedErrors(true);
            this.setAllowDuplicateKeys(true);
        }

        public Builder setCreateFileIfAbsent(boolean bl) {
            this.createFileIfAbsent = bl;
            return this;
        }

        public Builder setAutoUpdate(boolean bl) {
            this.autoUpdate = bl;
            return this;
        }

        public Builder setErrorLabel(@NotNull String string) {
            this.builder.setLabel(string);
            return this;
        }

        public Builder setDetailedErrors(boolean bl) {
            this.builder.setUseMarks(bl);
            return this;
        }

        public Builder setAllowDuplicateKeys(boolean bl) {
            this.builder.setAllowDuplicateKeys(bl);
            return this;
        }

        public Builder setMaxCollectionAliases(int n) {
            this.builder.setMaxAliasesForCollections(n);
            return this;
        }

        public Builder setTagConstructors(@NotNull Map<Tag, ConstructNode> map) {
            this.builder.setTagConstructors(map);
            return this;
        }

        public Builder setSchema(@NotNull Schema schema) {
            this.builder.setSchema(schema);
            return this;
        }

        public Builder setEnvironmentConfig(@Nullable EnvConfig envConfig) {
            this.builder.setEnvConfig(Optional.ofNullable(envConfig));
            return this;
        }

        public LoaderSettings build() {
            return new LoaderSettings(this);
        }
    }
}

