/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.settings.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.YamlDocument;
import xshyo.us.theglow.libs.config.dvs.Pattern;
import xshyo.us.theglow.libs.config.dvs.versioning.AutomaticVersioning;
import xshyo.us.theglow.libs.config.dvs.versioning.ManualVersioning;
import xshyo.us.theglow.libs.config.dvs.versioning.Versioning;
import xshyo.us.theglow.libs.config.route.Route;
import xshyo.us.theglow.libs.config.route.RouteFactory;
import xshyo.us.theglow.libs.config.settings.Settings;
import xshyo.us.theglow.libs.config.settings.updater.MergeRule;
import xshyo.us.theglow.libs.config.settings.updater.ValueMapper;

public class UpdaterSettings
implements Settings {
    public static final boolean DEFAULT_AUTO_SAVE = true;
    public static final boolean DEFAULT_ENABLE_DOWNGRADING = true;
    public static final boolean DEFAULT_KEEP_ALL = false;
    public static final OptionSorting DEFAULT_OPTION_SORTING = OptionSorting.SORT_BY_DEFAULTS;
    public static final Map<MergeRule, Boolean> DEFAULT_MERGE_RULES = Collections.unmodifiableMap(new HashMap<MergeRule, Boolean>(){
        {
            this.put(MergeRule.MAPPINGS, true);
            this.put(MergeRule.MAPPING_AT_SECTION, false);
            this.put(MergeRule.SECTION_AT_MAPPING, false);
        }
    });
    public static final Versioning DEFAULT_VERSIONING = null;
    public static final UpdaterSettings DEFAULT = UpdaterSettings.builder().build();
    private final boolean autoSave;
    private final boolean enableDowngrading;
    private final boolean keepAll;
    private final Map<MergeRule, Boolean> mergeRules;
    private final Map<String, RouteSet> ignored;
    private final Map<String, RouteMap<Route, String>> relocations;
    private final Map<String, Map<Route, ValueMapper>> mappers;
    private final Map<String, List<Consumer<YamlDocument>>> customLogic;
    private final Versioning versioning;
    private final OptionSorting optionSorting;

    public UpdaterSettings(Builder builder) {
        this.autoSave = builder.autoSave;
        this.enableDowngrading = builder.enableDowngrading;
        this.keepAll = builder.keepAll;
        this.optionSorting = builder.optionSorting;
        this.mergeRules = builder.mergeRules;
        this.ignored = builder.ignored;
        this.relocations = builder.relocations;
        this.mappers = builder.mappers;
        this.customLogic = builder.customLogic;
        this.versioning = builder.versioning;
    }

    public Map<MergeRule, Boolean> getMergeRules() {
        return this.mergeRules;
    }

    public Set<Route> getIgnoredRoutes(@NotNull String string, char c) {
        RouteSet routeSet = this.ignored.get(string);
        return routeSet == null ? Collections.emptySet() : routeSet.merge(c);
    }

    public Map<Route, Route> getRelocations(@NotNull String string2, char c) {
        RouteMap<Route, String> routeMap = this.relocations.get(string2);
        return routeMap == null ? Collections.emptyMap() : routeMap.merge(Function.identity(), string -> Route.fromString(string, c), c);
    }

    public Map<Route, ValueMapper> getMappers(@NotNull String string, char c) {
        return this.mappers.getOrDefault(string, Collections.emptyMap());
    }

    public List<Consumer<YamlDocument>> getCustomLogic(@NotNull String string) {
        return this.customLogic.getOrDefault(string, Collections.emptyList());
    }

    public Versioning getVersioning() {
        return this.versioning;
    }

    public boolean isEnableDowngrading() {
        return this.enableDowngrading;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public OptionSorting getOptionSorting() {
        return this.optionSorting;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UpdaterSettings updaterSettings) {
        return UpdaterSettings.builder().setAutoSave(updaterSettings.autoSave).setEnableDowngrading(updaterSettings.enableDowngrading).setKeepAll(updaterSettings.keepAll).setOptionSorting(updaterSettings.optionSorting).setMergeRules(updaterSettings.mergeRules).setIgnoredRoutesInternal(updaterSettings.ignored).setRelocationsInternal(updaterSettings.relocations).addMappers(updaterSettings.mappers).addCustomLogic(updaterSettings.customLogic).setVersioning(updaterSettings.versioning);
    }

    private static class RouteSet {
        private Set<Route> routes = null;
        private Set<String> strings = null;

        private RouteSet() {
        }

        public Set<Route> merge(char c) {
            if ((this.routes == null || this.routes.isEmpty()) && (this.strings == null || this.strings.isEmpty())) {
                return Collections.emptySet();
            }
            HashSet<Route> hashSet = new HashSet<Route>();
            if (this.strings != null) {
                this.strings.forEach(string -> hashSet.add(Route.fromString(string, c)));
            }
            if (this.routes != null) {
                hashSet.addAll(this.routes);
            }
            return hashSet;
        }

        public Set<Route> getRouteSet() {
            return this.routes == null ? (this.routes = new HashSet<Route>()) : this.routes;
        }

        public Set<String> getStringSet() {
            return this.strings == null ? (this.strings = new HashSet<String>()) : this.strings;
        }
    }

    private static class RouteMap<R, S> {
        private Map<Route, R> routes = null;
        private Map<String, S> strings = null;

        private RouteMap() {
        }

        @NotNull
        public <T> Map<Route, T> merge(@NotNull Function<R, T> function, @NotNull Function<S, T> function2, char c) {
            if ((this.routes == null || this.routes.isEmpty()) && (this.strings == null || this.strings.isEmpty())) {
                return Collections.emptyMap();
            }
            HashMap hashMap = new HashMap();
            if (this.strings != null) {
                this.strings.forEach((string, object) -> hashMap.put(Route.fromString(string, c), function2.apply(object)));
            }
            if (this.routes != null) {
                this.routes.forEach((route, object) -> hashMap.put(route, function.apply(object)));
            }
            return hashMap;
        }

        @NotNull
        public Map<Route, R> getRouteMap() {
            return this.routes == null ? (this.routes = new HashMap<Route, R>()) : this.routes;
        }

        @NotNull
        public Map<String, S> getStringMap() {
            return this.strings == null ? (this.strings = new HashMap<String, S>()) : this.strings;
        }
    }

    public static class Builder {
        private boolean autoSave = true;
        private boolean enableDowngrading = true;
        private boolean keepAll = false;
        private final Map<MergeRule, Boolean> mergeRules = new HashMap<MergeRule, Boolean>(DEFAULT_MERGE_RULES);
        private final Map<String, RouteSet> ignored = new HashMap<String, RouteSet>();
        private final Map<String, RouteMap<Route, String>> relocations = new HashMap<String, RouteMap<Route, String>>();
        private final Map<String, Map<Route, ValueMapper>> mappers = new HashMap<String, Map<Route, ValueMapper>>();
        private final Map<String, List<Consumer<YamlDocument>>> customLogic = new HashMap<String, List<Consumer<YamlDocument>>>();
        private Versioning versioning = DEFAULT_VERSIONING;
        private OptionSorting optionSorting = DEFAULT_OPTION_SORTING;

        private Builder() {
        }

        public Builder setAutoSave(boolean bl) {
            this.autoSave = bl;
            return this;
        }

        public Builder setEnableDowngrading(boolean bl) {
            this.enableDowngrading = bl;
            return this;
        }

        public Builder setKeepAll(boolean bl) {
            this.keepAll = bl;
            return this;
        }

        public Builder setOptionSorting(@NotNull OptionSorting optionSorting) {
            this.optionSorting = optionSorting;
            return this;
        }

        public Builder setMergeRules(@NotNull Map<MergeRule, Boolean> map) {
            this.mergeRules.putAll(map);
            return this;
        }

        public Builder setMergeRule(@NotNull MergeRule mergeRule, boolean bl) {
            this.mergeRules.put(mergeRule, bl);
            return this;
        }

        private Builder setIgnoredRoutesInternal(@NotNull Map<String, RouteSet> map) {
            this.ignored.putAll(map);
            return this;
        }

        @Deprecated
        public Builder setIgnoredRoutes(@NotNull Map<String, Set<Route>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getRouteSet().addAll((Collection<Route>)set));
            return this;
        }

        @Deprecated
        public Builder setIgnoredRoutes(@NotNull String string2, @NotNull Set<Route> set) {
            this.ignored.computeIfAbsent(string2, string -> new RouteSet()).getRouteSet().addAll(set);
            return this;
        }

        @Deprecated
        public Builder setIgnoredStringRoutes(@NotNull Map<String, Set<String>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getStringSet().addAll((Collection<String>)set));
            return this;
        }

        @Deprecated
        public Builder setIgnoredStringRoutes(@NotNull String string2, @NotNull Set<String> set) {
            this.ignored.computeIfAbsent(string2, string -> new RouteSet()).getStringSet().addAll(set);
            return this;
        }

        public Builder addIgnoredRoute(@NotNull String string, @NotNull Route route) {
            return this.addIgnoredRoutes(string, Collections.singleton(route));
        }

        public Builder addIgnoredRoutes(@NotNull String string, @NotNull Set<Route> set) {
            return this.addIgnoredRoutes(Collections.singletonMap(string, set));
        }

        public Builder addIgnoredRoutes(@NotNull Map<String, Set<Route>> map) {
            map.forEach((string2, set) -> this.ignored.computeIfAbsent((String)string2, string -> new RouteSet()).getRouteSet().addAll((Collection<Route>)set));
            return this;
        }

        public Builder addIgnoredRoute(@NotNull String string, @NotNull String string2, char c) {
            return this.addIgnoredRoutes(string, Collections.singleton(string2), c);
        }

        public Builder addIgnoredRoutes(@NotNull String string, @NotNull Set<String> set, char c) {
            this.addIgnoredRoutes(string, set, new RouteFactory(c));
            return this;
        }

        public Builder addIgnoredRoutes(@NotNull Map<String, Set<String>> map, char c) {
            RouteFactory routeFactory = new RouteFactory(c);
            map.forEach((string, set) -> this.addIgnoredRoutes((String)string, (Set<String>)set, routeFactory));
            return this;
        }

        private void addIgnoredRoutes(@NotNull String string2, @NotNull Set<String> set, @NotNull RouteFactory routeFactory) {
            Set<Route> set2 = this.ignored.computeIfAbsent(string2, string -> new RouteSet()).getRouteSet();
            set.forEach(string -> set2.add(routeFactory.create((String)string)));
        }

        private Builder setRelocationsInternal(@NotNull Map<String, RouteMap<Route, String>> map) {
            this.relocations.putAll(map);
            return this;
        }

        @Deprecated
        public Builder setRelocations(@NotNull Map<String, Map<Route, Route>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getRouteMap().putAll(map));
            return this;
        }

        @Deprecated
        public Builder setRelocations(@NotNull String string2, @NotNull Map<Route, Route> map) {
            this.relocations.computeIfAbsent(string2, string -> new RouteMap()).getRouteMap().putAll(map);
            return this;
        }

        @Deprecated
        public Builder setStringRelocations(@NotNull Map<String, Map<String, String>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getStringMap().putAll(map));
            return this;
        }

        @Deprecated
        public Builder setStringRelocations(@NotNull String string2, @NotNull Map<String, String> map) {
            this.relocations.computeIfAbsent(string2, string -> new RouteMap()).getStringMap().putAll(map);
            return this;
        }

        public Builder addRelocation(@NotNull String string, @NotNull Route route, @NotNull Route route2) {
            return this.addRelocations(string, Collections.singletonMap(route, route2));
        }

        public Builder addRelocations(@NotNull String string, @NotNull Map<Route, Route> map) {
            return this.addRelocations(Collections.singletonMap(string, map));
        }

        public Builder addRelocations(@NotNull Map<String, Map<Route, Route>> map2) {
            map2.forEach((string2, map) -> this.relocations.computeIfAbsent((String)string2, string -> new RouteMap()).getRouteMap().putAll(map));
            return this;
        }

        public Builder addRelocation(@NotNull String string, @NotNull String string2, @NotNull String string3, char c) {
            return this.addRelocations(string, Collections.singletonMap(string2, string3), c);
        }

        public Builder addRelocations(@NotNull String string, @NotNull Map<String, String> map, char c) {
            this.addRelocations(Collections.singletonMap(string, map), c);
            return this;
        }

        public Builder addRelocations(@NotNull Map<String, Map<String, String>> map2, char c) {
            RouteFactory routeFactory = new RouteFactory(c);
            map2.forEach((string3, map) -> {
                Map map2 = this.relocations.computeIfAbsent((String)string3, string -> new RouteMap()).getRouteMap();
                map.forEach((string, string2) -> map2.put(routeFactory.create((String)string), routeFactory.create((String)string2)));
            });
            return this;
        }

        public Builder addMapper(@NotNull String string, @NotNull Route route, @NotNull ValueMapper valueMapper) {
            return this.addMappers(string, Collections.singletonMap(route, valueMapper));
        }

        public Builder addMappers(@NotNull String string, @NotNull Map<Route, ValueMapper> map) {
            return this.addMappers(Collections.singletonMap(string, map));
        }

        public Builder addMappers(@NotNull Map<String, Map<Route, ValueMapper>> map2) {
            map2.forEach((string2, map) -> this.mappers.computeIfAbsent((String)string2, string -> new HashMap()).putAll(map));
            return this;
        }

        public Builder addMapper(@NotNull String string, @NotNull String string2, @NotNull ValueMapper valueMapper, char c) {
            return this.addMappers(string, Collections.singletonMap(string2, valueMapper), c);
        }

        public Builder addMappers(@NotNull String string, @NotNull Map<String, ValueMapper> map, char c) {
            return this.addMappers(Collections.singletonMap(string, map), c);
        }

        public Builder addMappers(@NotNull Map<String, Map<String, ValueMapper>> map2, char c) {
            RouteFactory routeFactory = new RouteFactory(c);
            map2.forEach((string2, map) -> {
                Map map2 = this.mappers.computeIfAbsent((String)string2, string -> new HashMap());
                map.forEach((string, valueMapper) -> map2.put(routeFactory.create((String)string), valueMapper));
            });
            return this;
        }

        public Builder addCustomLogic(@NotNull String string, @NotNull Consumer<YamlDocument> consumer) {
            return this.addCustomLogic(string, Collections.singletonList(consumer));
        }

        public Builder addCustomLogic(@NotNull Map<String, List<Consumer<YamlDocument>>> map) {
            map.forEach(this::addCustomLogic);
            return this;
        }

        public Builder addCustomLogic(@NotNull String string2, @NotNull Collection<Consumer<YamlDocument>> collection) {
            this.customLogic.computeIfAbsent(string2, string -> new ArrayList()).addAll(collection);
            return this;
        }

        public Builder setVersioning(@NotNull Versioning versioning) {
            this.versioning = versioning;
            return this;
        }

        public Builder setVersioning(@NotNull Pattern pattern, @Nullable String string, @NotNull String string2) {
            return this.setVersioning(new ManualVersioning(pattern, string, string2));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull Route route) {
            return this.setVersioning(new AutomaticVersioning(pattern, route));
        }

        public Builder setVersioning(@NotNull Pattern pattern, @NotNull String string) {
            return this.setVersioning(new AutomaticVersioning(pattern, string));
        }

        public UpdaterSettings build() {
            return new UpdaterSettings(this);
        }
    }

    public static enum OptionSorting {
        NONE,
        SORT_BY_DEFAULTS;

    }
}

