/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.settings.updater;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.block.Block;
import xshyo.us.theglow.libs.config.block.implementation.Section;
import xshyo.us.theglow.libs.config.route.Route;

public interface ValueMapper {
    @Nullable
    default public Object map(@NotNull Section section, @NotNull Route route) {
        return this.map(section.getBlock(route));
    }

    @Nullable
    default public Object map(@NotNull Block<?> block) {
        return this.map(block.getStoredValue());
    }

    @Nullable
    default public Object map(@Nullable Object object) {
        return object;
    }

    public static ValueMapper section(final BiFunction<Section, Route, Object> biFunction) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Section section, @NotNull Route route) {
                return biFunction.apply(section, route);
            }
        };
    }

    public static ValueMapper block(final Function<Block<?>, Object> function) {
        return new ValueMapper(){

            @Override
            public Object map(@NotNull Block<?> block) {
                return function.apply(block);
            }
        };
    }

    public static ValueMapper value(final Function<Object, Object> function) {
        return new ValueMapper(){

            @Override
            public Object map(@Nullable Object object) {
                return function.apply(object);
            }
        };
    }
}

