/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.updater;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.config.block.implementation.Section;
import xshyo.us.theglow.libs.config.dvs.Version;
import xshyo.us.theglow.libs.config.dvs.versioning.Versioning;
import xshyo.us.theglow.libs.config.route.Route;
import xshyo.us.theglow.libs.config.settings.updater.UpdaterSettings;
import xshyo.us.theglow.libs.config.updater.operators.Mapper;
import xshyo.us.theglow.libs.config.updater.operators.Relocator;

public class VersionedOperations {
    public static boolean run(@NotNull Section section, @NotNull Section section2, @NotNull UpdaterSettings updaterSettings, char c) {
        int n;
        Versioning versioning = updaterSettings.getVersioning();
        if (versioning == null) {
            return false;
        }
        Version version = versioning.getDocumentVersion(section, false);
        Version version2 = Objects.requireNonNull(versioning.getDocumentVersion(section2, true), "Version ID of the defaults cannot be null! Is it malformed or not specified?");
        int n2 = n = version != null ? version.compareTo(version2) : -1;
        if (n > 0 && !updaterSettings.isEnableDowngrading()) {
            throw new UnsupportedOperationException(String.format("Downgrading is not enabled (%s > %s)!", version2.asID(), version.asID()));
        }
        if (n == 0) {
            return true;
        }
        if (n < 0) {
            VersionedOperations.iterate(section, version != null ? version : versioning.getFirstVersion(), version2, updaterSettings, c);
        }
        updaterSettings.getIgnoredRoutes(version2.asID(), c).forEach(route -> section.getOptionalBlock((Route)route).ifPresent(block -> block.setIgnored(true)));
        return false;
    }

    private static void iterate(@NotNull Section section, @NotNull Version version, @NotNull Version version2, @NotNull UpdaterSettings updaterSettings, char c) {
        Version version3 = version.copy();
        while (version3.compareTo(version2) <= 0) {
            version3.next();
            Relocator.apply(section, updaterSettings.getRelocations(version3.asID(), c));
            Mapper.apply(section, updaterSettings.getMappers(version3.asID(), c));
            updaterSettings.getCustomLogic(version3.asID()).forEach(consumer -> consumer.accept(section.getRoot()));
        }
    }
}

