/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.updater.operators;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.config.YamlDocument;
import xshyo.us.theglow.libs.config.block.Block;
import xshyo.us.theglow.libs.config.block.implementation.Section;
import xshyo.us.theglow.libs.config.block.implementation.TerminatedBlock;
import xshyo.us.theglow.libs.config.engine.ExtendedConstructor;
import xshyo.us.theglow.libs.config.engine.ExtendedRepresenter;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Node;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import xshyo.us.theglow.libs.config.libs.org.snakeyaml.engine.v2.nodes.Tag;
import xshyo.us.theglow.libs.config.route.Route;
import xshyo.us.theglow.libs.config.settings.general.GeneralSettings;
import xshyo.us.theglow.libs.config.settings.updater.MergeRule;
import xshyo.us.theglow.libs.config.settings.updater.UpdaterSettings;

public class Merger {
    private static final Merger INSTANCE = new Merger();

    public static void merge(@NotNull Section section, @NotNull Section section2, @NotNull UpdaterSettings updaterSettings) {
        INSTANCE.iterate(section, section2, updaterSettings);
    }

    private void iterate(Section section, Section section2, UpdaterSettings updaterSettings) {
        Object object2;
        Object object3;
        HashSet hashSet = new HashSet(((Map)section.getStoredValue()).keySet());
        boolean bl = updaterSettings.getOptionSorting() == UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS;
        Map<Object, Block<?>> map = bl ? section.getRoot().getGeneralSettings().getDefaultMap() : null;
        for (Map.Entry entry : ((Map)section2.getStoredValue()).entrySet()) {
            object3 = entry.getKey();
            object2 = Route.from(object3);
            hashSet.remove(object3);
            Block block = section.getOptionalBlock((Route)object2).orElse(null);
            Block block2 = (Block)entry.getValue();
            if (block != null) {
                if (block.isIgnored()) {
                    block.setIgnored(false);
                    if (block instanceof Section) {
                        this.resetIgnored((Section)block);
                    }
                    if (!bl) continue;
                    map.put(object3, block);
                    continue;
                }
                boolean bl2 = block instanceof Section;
                boolean bl3 = block2 instanceof Section;
                if (bl3 && bl2) {
                    this.iterate((Section)block, (Section)block2, updaterSettings);
                    if (!bl) continue;
                    map.put(object3, block);
                    continue;
                }
                if (bl) {
                    map.put(object3, this.getPreservedValue(updaterSettings.getMergeRules(), block, () -> this.cloneBlock(block2, section), bl2, bl3));
                    continue;
                }
                section.set((Route)object2, this.getPreservedValue(updaterSettings.getMergeRules(), block, () -> this.cloneBlock(block2, section), bl2, bl3));
                continue;
            }
            if (bl) {
                map.put(object3, this.cloneBlock(block2, section));
                continue;
            }
            section.set((Route)object2, this.cloneBlock(block2, section));
        }
        if (updaterSettings.isKeepAll()) {
            if (bl) {
                hashSet.forEach(object -> {
                    Block cfr_ignored_0 = (Block)map.put(object, (Block<?>)((Map)section.getStoredValue()).get(object));
                });
                section.repopulate(map);
            }
            return;
        }
        for (Map.Entry entry : hashSet) {
            object3 = Route.fromSingleKey(entry);
            object2 = section.getOptionalBlock((Route)object3).orElse(null);
            if (object2 != null && ((Block)object2).isIgnored()) {
                ((Block)object2).setIgnored(false);
                if (object2 instanceof Section) {
                    this.resetIgnored((Section)object2);
                }
                if (!bl) continue;
                map.put(entry, (Block<?>)object2);
                continue;
            }
            if (bl) continue;
            section.remove((Route)object3);
        }
        if (bl) {
            section.repopulate(map);
        }
    }

    private void resetIgnored(@NotNull Section section) {
        ((Map)section.getStoredValue()).values().forEach(block -> {
            block.setIgnored(false);
            if (block instanceof Section) {
                this.resetIgnored((Section)block);
            }
        });
    }

    @NotNull
    private Block<?> cloneBlock(@NotNull Block<?> block, @NotNull Section section) {
        return block instanceof Section ? this.cloneSection((Section)block, section) : this.cloneTerminated((TerminatedBlock)block, section);
    }

    @NotNull
    private Section cloneSection(@NotNull Section section, @NotNull Section section2) {
        if (section.getRoute() == null) {
            throw new IllegalArgumentException("Cannot clone the root!");
        }
        YamlDocument yamlDocument = section.getRoot();
        GeneralSettings generalSettings = yamlDocument.getGeneralSettings();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter(generalSettings, yamlDocument.getDumperSettings());
        ExtendedConstructor extendedConstructor = new ExtendedConstructor(yamlDocument.getLoaderSettings().buildEngineSettings(generalSettings), generalSettings.getSerializer());
        Node node = extendedRepresenter.represent(section);
        extendedConstructor.constructSingleDocument(Optional.of(node));
        section = new Section(section2.getRoot(), section2, section.getRoute(), this.moveComments(node), (MappingNode)node, extendedConstructor);
        extendedConstructor.clear();
        return section;
    }

    @NotNull
    private TerminatedBlock cloneTerminated(@NotNull TerminatedBlock terminatedBlock, @NotNull Section section) {
        YamlDocument yamlDocument = section.getRoot();
        GeneralSettings generalSettings = yamlDocument.getGeneralSettings();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter(generalSettings, yamlDocument.getDumperSettings());
        ExtendedConstructor extendedConstructor = new ExtendedConstructor(yamlDocument.getLoaderSettings().buildEngineSettings(generalSettings), generalSettings.getSerializer());
        Node node = extendedRepresenter.represent(terminatedBlock.getStoredValue());
        extendedConstructor.constructSingleDocument(Optional.of(node));
        terminatedBlock = new TerminatedBlock((Block<?>)terminatedBlock, extendedConstructor.getConstructed(node));
        extendedConstructor.clear();
        return terminatedBlock;
    }

    private Node moveComments(@NotNull Node node) {
        ScalarNode scalarNode = new ScalarNode(Tag.STR, "", ScalarStyle.PLAIN);
        scalarNode.setBlockComments(node.getBlockComments());
        scalarNode.setInLineComments(node.getInLineComments());
        scalarNode.setEndComments(node.getEndComments());
        node.setBlockComments(Collections.emptyList());
        node.setInLineComments(null);
        node.setEndComments(null);
        return scalarNode;
    }

    @NotNull
    private Block<?> getPreservedValue(@NotNull Map<MergeRule, Boolean> map, @NotNull Block<?> block, @NotNull Supplier<Block<?>> supplier, boolean bl, boolean bl2) {
        return map.get((Object)MergeRule.getFor(bl, bl2)) != false ? block : supplier.get();
    }
}

