/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.utils.conversion;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.config.utils.conversion.PrimitiveConversions;

public class ListConversions {
    @NotNull
    public static Optional<List<String>> toStringList(@Nullable List<?> list) {
        return ListConversions.construct(list, object -> Optional.ofNullable(object.toString()));
    }

    @NotNull
    public static Optional<List<Integer>> toIntList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toInt);
    }

    @NotNull
    public static Optional<List<BigInteger>> toBigIntList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toBigInt);
    }

    @NotNull
    public static Optional<List<Byte>> toByteList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toByte);
    }

    @NotNull
    public static Optional<List<Long>> toLongList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toLong);
    }

    @NotNull
    public static Optional<List<Double>> toDoubleList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toDouble);
    }

    @NotNull
    public static Optional<List<Float>> toFloatList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toFloat);
    }

    @NotNull
    public static Optional<List<Short>> toShortList(@Nullable List<?> list) {
        return ListConversions.construct(list, PrimitiveConversions::toShort);
    }

    @NotNull
    public static Optional<List<Map<?, ?>>> toMapList(@Nullable List<?> list) {
        return ListConversions.construct(list, object -> object instanceof Map ? Optional.of((Map)object) : Optional.empty());
    }

    @NotNull
    private static <T> Optional<List<T>> construct(@Nullable List<?> list, @NotNull Function<Object, Optional<T>> function) {
        if (list == null) {
            return Optional.empty();
        }
        ArrayList arrayList = new ArrayList();
        for (Object obj : list) {
            if (obj == null) continue;
            function.apply(obj).ifPresent(arrayList::add);
        }
        return Optional.of(arrayList);
    }
}

