/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.config.utils.conversion;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveConversions {
    public static final Map<Class<?>, Class<?>> NUMERIC_PRIMITIVES = Collections.unmodifiableMap(new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Integer.TYPE, Integer.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Short.TYPE, Short.class);
            this.put(Long.TYPE, Long.class);
            this.put(Float.TYPE, Float.class);
            this.put(Double.TYPE, Double.class);
        }
    });
    public static final Map<Class<?>, Class<?>> PRIMITIVES_TO_OBJECTS = Collections.unmodifiableMap(new HashMap<Class<?>, Class<?>>(){
        {
            this.putAll(NUMERIC_PRIMITIVES);
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
        }
    });
    public static final Map<Class<?>, Class<?>> NON_NUMERIC_CONVERSIONS = Collections.unmodifiableMap(new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Character.TYPE, Character.class);
            this.put(Boolean.class, Boolean.TYPE);
            this.put(Character.class, Character.TYPE);
        }
    });
    public static final Set<Class<?>> NUMERIC_CLASSES = Collections.unmodifiableSet(new HashSet<Class<?>>(){
        {
            this.add(Integer.TYPE);
            this.add(Byte.TYPE);
            this.add(Short.TYPE);
            this.add(Long.TYPE);
            this.add(Float.TYPE);
            this.add(Double.TYPE);
            this.add(Integer.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
        }
    });

    public static boolean isNumber(@NotNull Class<?> clazz) {
        return NUMERIC_CLASSES.contains(clazz);
    }

    public static Object convertNumber(@NotNull Object object, @NotNull Class<?> clazz) {
        Number number = (Number)object;
        boolean bl = clazz.isPrimitive();
        if (bl) {
            clazz = NUMERIC_PRIMITIVES.get(clazz);
        }
        if (clazz == Integer.class) {
            return number.intValue();
        }
        if (clazz == Byte.class) {
            return number.byteValue();
        }
        if (clazz == Short.class) {
            return number.shortValue();
        }
        if (clazz == Long.class) {
            return number.longValue();
        }
        if (clazz == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        return number.doubleValue();
    }

    public static Optional<Integer> toInt(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(((Number)object).intValue());
        }
        try {
            return Optional.of(Integer.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Byte> toByte(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(((Number)object).byteValue());
        }
        try {
            return Optional.of(Byte.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Long> toLong(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(((Number)object).longValue());
        }
        try {
            return Optional.of(Long.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Double> toDouble(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(((Number)object).doubleValue());
        }
        try {
            return Optional.of(Double.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Float> toFloat(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(Float.valueOf(((Number)object).floatValue()));
        }
        try {
            return Optional.of(Float.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Short> toShort(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof Number) {
            return Optional.of(((Number)object).shortValue());
        }
        try {
            return Optional.of(Short.valueOf(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<BigInteger> toBigInt(@Nullable Object object) {
        if (object == null) {
            return Optional.empty();
        }
        if (object instanceof BigInteger) {
            return Optional.of((BigInteger)object);
        }
        if (object instanceof Number) {
            return Optional.of(BigInteger.valueOf(((Number)object).longValue()));
        }
        try {
            return Optional.of(new BigInteger(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }
}

