/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.guis.builder.gui;

import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.guis.builder.gui.BaseGuiBuilder;
import xshyo.us.theglow.libs.guis.components.ScrollType;
import xshyo.us.theglow.libs.guis.components.util.Legacy;
import xshyo.us.theglow.libs.guis.guis.ScrollingGui;

public final class ScrollingBuilder
extends BaseGuiBuilder<ScrollingGui, ScrollingBuilder> {
    private ScrollType scrollType;
    private int pageSize = 0;

    public ScrollingBuilder(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder scrollType(@NotNull ScrollType scrollType) {
        this.scrollType = scrollType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public ScrollingBuilder pageSize(int n) {
        this.pageSize = n;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public ScrollingGui create() {
        ScrollingGui scrollingGui = new ScrollingGui(this.getRows(), this.pageSize, Legacy.SERIALIZER.serialize(this.getTitle()), this.scrollType, this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(scrollingGui);
        }
        return scrollingGui;
    }
}

