/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.actions.ActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.ActionBarActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.BroadcastActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.CloseActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.CommandActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.ConsoleLogActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.FireworkActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.MessageActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.NegativePermissionActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.OPCommandActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.PermissionActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.PlayerChatActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.SoundActionHandler;
import xshyo.us.theglow.libs.theAPI.actions.handler.TitleActionHandler;
import xshyo.us.theglow.libs.theAPI.utilities.Utils;

public class ActionExecutor {
    private final Map<String, ActionHandler> actionHandlers = new HashMap<String, ActionHandler>();
    private final Map<UUID, Set<BukkitTask>> pendingTasks = new HashMap<UUID, Set<BukkitTask>>();

    public ActionExecutor() {
        this.actionHandlers.put("[command]", new CommandActionHandler());
        this.actionHandlers.put("[player]", new PlayerChatActionHandler());
        this.actionHandlers.put("[message]", new MessageActionHandler());
        this.actionHandlers.put("[sound]", new SoundActionHandler());
        this.actionHandlers.put("[broadcast]", new BroadcastActionHandler());
        this.actionHandlers.put("[log]", new ConsoleLogActionHandler());
        this.actionHandlers.put("[title]", new TitleActionHandler());
        this.actionHandlers.put("[effect]", new TitleActionHandler());
        this.actionHandlers.put("[close]", new CloseActionHandler());
        this.actionHandlers.put("[actionbar]", new ActionBarActionHandler());
        this.actionHandlers.put("[firework]", new FireworkActionHandler());
        this.actionHandlers.put("[permission]", new PermissionActionHandler());
        this.actionHandlers.put("[!permission]", new NegativePermissionActionHandler());
        this.actionHandlers.put("[opcommand]", new OPCommandActionHandler());
    }

    public void finalExecuteActions(Player player, List<String> list) {
        for (String string : list) {
            String string2;
            string = string.trim();
            String[] stringArray = string.split("\\s+", 2);
            String string3 = stringArray[0].toLowerCase();
            String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
            if (string3.startsWith("[chance=")) {
                if (!Utils.shouldExecuteAction(string3)) continue;
                this.executeAction(player, string2, new HashMap<String, String>());
                continue;
            }
            this.executeAction(player, string, new HashMap<String, String>());
        }
    }

    public void finalExecuteActions(Player player, List<String> list, Map<String, String> map) {
        for (String string : list) {
            String string2;
            string = string.trim();
            String[] stringArray = string.split("\\s+", 2);
            String string3 = stringArray[0].toLowerCase();
            String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
            if (string3.startsWith("[chance=")) {
                if (!Utils.shouldExecuteAction(string3)) continue;
                this.executeAction(player, string2, map);
                continue;
            }
            this.executeAction(player, string, map);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeAction(Player player, String string, Map<String, String> map) {
        void var8_14;
        Object object;
        void var8_12;
        int n;
        int n2;
        String[] stringArray = string.split("\\s+", 2);
        String string2 = stringArray[0].toLowerCase();
        String string3 = stringArray.length > 1 ? stringArray[1].replace("{player}", player.getName()) : "";
        string3 = Utils.setPAPI(player, string3);
        for (Map.Entry<String, String> object22 : map.entrySet()) {
            string3 = string3.replace(object22.getKey(), object22.getValue());
        }
        int n3 = 0;
        if (string3.contains("<delay=") && string3.contains(">")) {
            n2 = string3.indexOf("<delay=") + "<delay=".length();
            n = string3.indexOf(">", n2);
            if (n2 != -1 && n != -1) {
                try {
                    n3 = Integer.parseInt(string3.substring(n2, n));
                }
                catch (NumberFormatException numberFormatException) {
                    Bukkit.getLogger().log(Level.WARNING, "Actions Incorrect delay format. Using default delay.");
                }
            }
            String string4 = string3.replace(string3.substring(n2 - "<delay=".length(), n + 1), "");
        } else {
            String string5 = string3;
        }
        if (var8_12.contains("<center>") && var8_12.contains("</center>")) {
            n2 = var8_12.indexOf("<center>") + "<center>".length();
            n = var8_12.indexOf("</center>", n2);
            if (n2 != -1 && n != -1) {
                object = var8_12.substring(n2, n);
                object = this.centerText((String)object);
                String string6 = var8_12.replace("<center>" + var8_12.substring(n2, n) + "</center>", (CharSequence)object);
            }
        }
        void var9_16 = var8_14;
        ActionHandler actionHandler = this.actionHandlers.get(string2);
        if (actionHandler != null) {
            if (n3 > 0) {
                object = Bukkit.getScheduler().runTaskLater((Plugin)TheAPI.getInstance(), () -> ActionExecutor.lambda$executeAction$0(actionHandler, player, (String)var9_16), (long)n3);
                this.pendingTasks.computeIfAbsent(player.getUniqueId(), uUID -> new HashSet()).add(object);
            } else {
                actionHandler.execute(player, (String)var9_16, 0);
            }
        } else {
            Bukkit.getLogger().log(Level.WARNING, "Actions Formato incorrecto: " + string2);
        }
    }

    public void cancelPendingTasks(UUID uUID) {
        Set<BukkitTask> set = this.pendingTasks.get(uUID);
        if (set != null) {
            set.forEach(BukkitTask::cancel);
            set.clear();
            this.pendingTasks.remove(uUID);
        }
    }

    private String centerText(String string) {
        int n = 80;
        int n2 = string.replaceAll("\u00a7[0-9a-fk-or]", "").length();
        int n3 = (n - n2) / 2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public Map<String, ActionHandler> getActionHandlers() {
        return this.actionHandlers;
    }

    public Map<UUID, Set<BukkitTask>> getPendingTasks() {
        return this.pendingTasks;
    }

    private static /* synthetic */ void lambda$executeAction$0(ActionHandler actionHandler, Player player, String string) {
        actionHandler.execute(player, string, 0);
    }
}

