/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.actions.handler;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.actions.ActionHandler;

public class FireworkActionHandler
implements ActionHandler {
    @Override
    public void execute(Player player, String string, int n) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (n > 0) {
            TheAPI.getInstance().getScheduler().runTaskLater(() -> this.spawnFirework(player, string), n);
        } else {
            TheAPI.getInstance().getScheduler().runTask(() -> this.spawnFirework(player, string));
        }
    }

    private void spawnFirework(Player player, String string) {
        try {
            FireworkOptions fireworkOptions = this.parseOptions(string);
            Firework firework = (Firework)player.getWorld().spawn(player.getLocation(), Firework.class);
            FireworkMeta fireworkMeta = firework.getFireworkMeta();
            FireworkEffect.Builder builder = FireworkEffect.builder();
            if (!fireworkOptions.colors.isEmpty()) {
                for (org.bukkit.Color color : fireworkOptions.colors) {
                    builder.withColor(color);
                }
            } else {
                builder.withColor(org.bukkit.Color.RED);
            }
            if (!fireworkOptions.fadeColors.isEmpty()) {
                for (org.bukkit.Color color : fireworkOptions.fadeColors) {
                    builder.withFade(color);
                }
            }
            if (fireworkOptions.type != null) {
                builder.with(fireworkOptions.type);
            } else {
                builder.with(FireworkEffect.Type.BALL);
            }
            if (fireworkOptions.flicker) {
                builder.withFlicker();
            }
            if (fireworkOptions.trail) {
                builder.withTrail();
            }
            FireworkEffect fireworkEffect = builder.build();
            fireworkMeta.addEffect(fireworkEffect);
            fireworkMeta.setPower(fireworkOptions.power);
            firework.setFireworkMeta(fireworkMeta);
            Bukkit.getLogger().info("[TheAPI] Spawned firework for player " + player.getName() + " with options: " + String.valueOf(fireworkOptions));
        }
        catch (Exception exception) {
            Bukkit.getLogger().warning("[TheAPI] Failed to spawn firework: " + exception.getMessage());
            this.spawnDefaultFirework(player);
        }
    }

    private void spawnDefaultFirework(Player player) {
        Firework firework = (Firework)player.getWorld().spawn(player.getLocation(), Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(org.bukkit.Color.RED).withColor(org.bukkit.Color.BLUE).with(FireworkEffect.Type.BALL).build();
        fireworkMeta.addEffect(fireworkEffect);
        fireworkMeta.setPower(1);
        firework.setFireworkMeta(fireworkMeta);
        Bukkit.getLogger().info("[TheAPI] Spawned default firework for player " + player.getName());
    }

    private FireworkOptions parseOptions(String string) {
        String[] stringArray;
        FireworkOptions fireworkOptions = new FireworkOptions();
        if (string == null || string.trim().isEmpty()) {
            return fireworkOptions;
        }
        for (String string2 : stringArray = string.split(";")) {
            if ((string2 = string2.trim()).startsWith("colors=")) {
                fireworkOptions.colors = this.parseColors(string2.substring("colors=".length()));
                continue;
            }
            if (string2.startsWith("fade=")) {
                fireworkOptions.fadeColors = this.parseColors(string2.substring("fade=".length()));
                continue;
            }
            if (string2.startsWith("type=")) {
                String string3 = string2.substring("type=".length()).toUpperCase();
                try {
                    fireworkOptions.type = FireworkEffect.Type.valueOf((String)string3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Bukkit.getLogger().warning("[TheAPI] Invalid firework type: " + string3);
                }
                continue;
            }
            if (string2.startsWith("power=")) {
                try {
                    int n = Integer.parseInt(string2.substring("power=".length()));
                    fireworkOptions.power = Math.max(0, Math.min(4, n));
                }
                catch (NumberFormatException numberFormatException) {
                    Bukkit.getLogger().warning("[TheAPI] Invalid power value: " + string2);
                }
                continue;
            }
            if (string2.startsWith("flicker=")) {
                fireworkOptions.flicker = Boolean.parseBoolean(string2.substring("flicker=".length()));
                continue;
            }
            if (!string2.startsWith("trail=")) continue;
            fireworkOptions.trail = Boolean.parseBoolean(string2.substring("trail=".length()));
        }
        return fireworkOptions;
    }

    private List<org.bukkit.Color> parseColors(String string) {
        String[] stringArray;
        ArrayList<org.bukkit.Color> arrayList = new ArrayList<org.bukkit.Color>();
        block45: for (String string2 : stringArray = string.split(",")) {
            Object object;
            if ((string2 = string2.trim().toUpperCase()).matches("^\\d+,\\d+,\\d+$")) {
                object = string2.split(",");
                try {
                    int n = Integer.parseInt(object[0].trim());
                    int n2 = Integer.parseInt(((String)object[1]).trim());
                    int n3 = Integer.parseInt(((String)object[2]).trim());
                    n = Math.max(0, Math.min(255, n));
                    n2 = Math.max(0, Math.min(255, n2));
                    n3 = Math.max(0, Math.min(255, n3));
                    arrayList.add(org.bukkit.Color.fromRGB((int)n, (int)n2, (int)n3));
                }
                catch (NumberFormatException numberFormatException) {
                    Bukkit.getLogger().warning("[TheAPI] Invalid RGB color: " + string2);
                }
                continue;
            }
            try {
                object = (Color)Color.class.getField(string2).get(null);
                arrayList.add(org.bukkit.Color.fromRGB((int)((Color)object).getRed(), (int)((Color)object).getGreen(), (int)((Color)object).getBlue()));
            }
            catch (Exception exception) {
                switch (string2) {
                    case "RED": {
                        arrayList.add(org.bukkit.Color.RED);
                        continue block45;
                    }
                    case "BLUE": {
                        arrayList.add(org.bukkit.Color.BLUE);
                        continue block45;
                    }
                    case "GREEN": {
                        arrayList.add(org.bukkit.Color.GREEN);
                        continue block45;
                    }
                    case "YELLOW": {
                        arrayList.add(org.bukkit.Color.YELLOW);
                        continue block45;
                    }
                    case "PURPLE": {
                        arrayList.add(org.bukkit.Color.PURPLE);
                        continue block45;
                    }
                    case "ORANGE": {
                        arrayList.add(org.bukkit.Color.ORANGE);
                        continue block45;
                    }
                    case "BLACK": {
                        arrayList.add(org.bukkit.Color.BLACK);
                        continue block45;
                    }
                    case "WHITE": {
                        arrayList.add(org.bukkit.Color.WHITE);
                        continue block45;
                    }
                    case "GRAY": 
                    case "GREY": {
                        arrayList.add(org.bukkit.Color.GRAY);
                        continue block45;
                    }
                    case "AQUA": 
                    case "CYAN": {
                        arrayList.add(org.bukkit.Color.AQUA);
                        continue block45;
                    }
                    case "PINK": 
                    case "FUCHSIA": {
                        arrayList.add(org.bukkit.Color.fromRGB((int)255, (int)105, (int)180));
                        continue block45;
                    }
                    case "LIME": {
                        arrayList.add(org.bukkit.Color.LIME);
                        continue block45;
                    }
                    case "SILVER": {
                        arrayList.add(org.bukkit.Color.SILVER);
                        continue block45;
                    }
                    case "NAVY": {
                        arrayList.add(org.bukkit.Color.NAVY);
                        continue block45;
                    }
                    case "OLIVE": {
                        arrayList.add(org.bukkit.Color.OLIVE);
                        continue block45;
                    }
                    case "MAROON": {
                        arrayList.add(org.bukkit.Color.MAROON);
                        continue block45;
                    }
                    case "TEAL": {
                        arrayList.add(org.bukkit.Color.TEAL);
                        continue block45;
                    }
                    default: {
                        Bukkit.getLogger().warning("[TheAPI] Unknown color: " + string2);
                    }
                }
            }
        }
        return arrayList;
    }

    private static class FireworkOptions {
        List<org.bukkit.Color> colors = new ArrayList<org.bukkit.Color>();
        List<org.bukkit.Color> fadeColors = new ArrayList<org.bukkit.Color>();
        FireworkEffect.Type type = FireworkEffect.Type.BALL;
        int power = 1;
        boolean flicker = false;
        boolean trail = false;

        private FireworkOptions() {
        }

        public String toString() {
            return "colors=" + this.colors.size() + ", fadeColors=" + this.fadeColors.size() + ", type=" + String.valueOf(this.type) + ", power=" + this.power + ", flicker=" + this.flicker + ", trail=" + this.trail;
        }
    }
}

