/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.actions.handler;

import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.actions.ActionHandler;

public class NegativePermissionActionHandler
implements ActionHandler {
    @Override
    public void execute(Player player, String string, int n) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!this.isVaultAvailable()) {
            Bukkit.getLogger().warning("[TheAPI] Could not execute remove permission action: Vault is not available");
            return;
        }
        if (n > 0) {
            TheAPI.getInstance().getScheduler().runTaskLater(() -> this.removePermission(player, string), n);
        } else {
            TheAPI.getInstance().getScheduler().runTask(() -> this.removePermission(player, string));
        }
    }

    private void removePermission(Player player, String string) {
        Permission permission = this.getVaultPermission();
        if (permission != null) {
            Bukkit.getLogger().info("[TheAPI] Attempting to remove permission '" + string + "' from player " + player.getName());
            boolean bl = permission.playerHas(player, string);
            if (bl) {
                Bukkit.getLogger().info("[TheAPI] Player " + player.getName() + " had permission '" + string + "' before removing it");
            } else {
                Bukkit.getLogger().info("[TheAPI] Player " + player.getName() + " did NOT have permission '" + string + "' before attempting to remove it");
            }
            boolean bl2 = permission.playerRemove(player, string);
            if (bl2) {
                Bukkit.getLogger().info("[TheAPI] Permission '" + string + "' successfully removed from player " + player.getName());
            } else {
                Bukkit.getLogger().warning("[TheAPI] Could not remove permission '" + string + "' from player " + player.getName() + ". Operation failed.");
            }
            if (!permission.playerHas(player, string)) {
                Bukkit.getLogger().info("[TheAPI] Verified: Player " + player.getName() + " no longer has permission '" + string + "'");
            } else {
                Bukkit.getLogger().warning("[TheAPI] Verification failed: Player " + player.getName() + " still has permission '" + string + "' after attempting to remove it");
            }
            Bukkit.getLogger().info("[TheAPI] Permission provider used: " + permission.getName());
        } else {
            Bukkit.getLogger().warning("[TheAPI] Could not remove permission: Vault is not available");
        }
    }

    private Permission getVaultPermission() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            return (Permission)registeredServiceProvider.getProvider();
        }
        return null;
    }

    private boolean isVaultAvailable() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Vault");
        if (plugin == null || !plugin.isEnabled()) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null && registeredServiceProvider.getProvider() != null) {
            Bukkit.getLogger().info("[TheAPI] Vault available with provider: " + ((Permission)registeredServiceProvider.getProvider()).getName());
            return true;
        }
        return false;
    }
}

