/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.actions.handler;

import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.actions.ActionHandler;

public class PermissionActionHandler
implements ActionHandler {
    @Override
    public void execute(Player player, String string, int n) {
        if (player == null || !player.isOnline()) {
            return;
        }
        if (!this.isVaultAvailable()) {
            Bukkit.getLogger().warning("[TheAPI] Could not execute permission action: Vault is not available");
            return;
        }
        if (n > 0) {
            TheAPI.getInstance().getScheduler().runTaskLater(() -> this.addPermission(player, string), n);
        } else {
            TheAPI.getInstance().getScheduler().runTask(() -> this.addPermission(player, string));
        }
    }

    private void addPermission(Player player, String string) {
        Permission permission = this.getVaultPermission();
        if (permission != null) {
            Bukkit.getLogger().info("[TheAPI] Attempting to add permission '" + string + "' to player " + player.getName());
            boolean bl = permission.playerAdd(player, string);
            if (bl) {
                Bukkit.getLogger().info("[TheAPI] Permission '" + string + "' successfully added to player " + player.getName());
            } else {
                Bukkit.getLogger().warning("[TheAPI] Could not add permission '" + string + "' to player " + player.getName() + ". Operation failed.");
            }
            if (permission.playerHas(player, string)) {
                Bukkit.getLogger().info("[TheAPI] Verified: Player " + player.getName() + " now has permission '" + string + "'");
            } else {
                Bukkit.getLogger().warning("[TheAPI] Verification failed: Player " + player.getName() + " does NOT have permission '" + string + "' after attempting to add it");
            }
            Bukkit.getLogger().info("[TheAPI] Permission provider used: " + permission.getName());
        } else {
            Bukkit.getLogger().warning("[TheAPI] Could not add permission: Vault is not available");
        }
    }

    private Permission getVaultPermission() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null) {
            return (Permission)registeredServiceProvider.getProvider();
        }
        return null;
    }

    private boolean isVaultAvailable() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Vault");
        if (plugin == null || !plugin.isEnabled()) {
            return false;
        }
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Permission.class);
        if (registeredServiceProvider != null && registeredServiceProvider.getProvider() != null) {
            Bukkit.getLogger().info("[TheAPI] Vault available with provider: " + ((Permission)registeredServiceProvider.getProvider()).getName());
            return true;
        }
        return false;
    }
}

