/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.commands;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;

public abstract class AbstractCommand
implements CommandExecutor,
TabCompleter {
    protected final String command;
    protected final String description;
    protected final List<String> alias;
    protected final String usage;
    protected final String permMessage;
    protected final Plugin plugin;
    protected String permission;
    protected static CommandMap cmap;
    private static final Map<String, Field> fieldCache;
    private static final Map<String, Method> methodCache;
    private static final Map<String, Class<?>> classCache;
    private static String serverVersion;
    private static int majorVersion;
    private static int minorVersion;
    private static boolean isPaper;
    private static boolean isSpigot;
    private static final CommandMap commandMap;
    private static final Field knownCommands;
    private static boolean loaded;
    private static final List<AbstractCommand> list;

    public AbstractCommand(String string) {
        this(string, null, null, null, null, null);
    }

    public AbstractCommand(String string, String string2) {
        this(string, string2, null, null, null, null);
    }

    public AbstractCommand(String string, String string2, String string3) {
        this(string, string2, string3, null, null, null);
    }

    public AbstractCommand(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, null, null);
    }

    public AbstractCommand(String string, String string2, String string3, List<String> list) {
        this(string, string2, string3, null, list, null);
    }

    public AbstractCommand(String string, String string2, String string3, String string4, List<String> list) {
        this(string, string2, string3, string4, list, null);
    }

    public AbstractCommand(String string, String string2, String string3, String string4, List<String> list, Plugin plugin) {
        this.command = string.toLowerCase();
        this.usage = string2;
        this.description = string3;
        this.permMessage = string4;
        this.alias = list;
        this.plugin = plugin;
    }

    private static void detectServerInfo() {
        try {
            String string = Bukkit.getServer().getClass().getPackage().getName();
            Pattern pattern = Pattern.compile("v(\\d+)_(\\d+)_R\\d+");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                majorVersion = Integer.parseInt(matcher.group(1));
                minorVersion = Integer.parseInt(matcher.group(2));
                serverVersion = majorVersion + "." + minorVersion;
            } else {
                String[] stringArray;
                String string2 = Bukkit.getBukkitVersion();
                if (string2.contains("1.") && (stringArray = string2.split("\\.")).length >= 2) {
                    majorVersion = Integer.parseInt(stringArray[0]);
                    minorVersion = Integer.parseInt(stringArray[1].split("-")[0]);
                    serverVersion = majorVersion + "." + minorVersion;
                }
            }
            isPaper = AbstractCommand.checkPaperServer();
            isSpigot = AbstractCommand.checkSpigotServer();
        }
        catch (Exception exception) {
            majorVersion = 1;
            minorVersion = 20;
            serverVersion = "1.20";
        }
    }

    public static void enable() {
        loaded = true;
        for (AbstractCommand abstractCommand : list) {
            abstractCommand.register();
        }
        list.clear();
        AbstractCommand.scheduleCommandSync();
    }

    public static void removePluginCommands(Plugin plugin) {
        try {
            Map map = (Map)knownCommands.get(commandMap);
            if (map == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : map.entrySet()) {
                Command command = (Command)entry.getValue();
                if (command instanceof PluginIdentifiableCommand) {
                    PluginIdentifiableCommand pluginIdentifiableCommand = (PluginIdentifiableCommand)command;
                    if (pluginIdentifiableCommand.getPlugin() != plugin) continue;
                    hashSet.add((String)entry.getKey());
                    continue;
                }
                if (!AbstractCommand.isPluginCommand(command, plugin)) continue;
                hashSet.add((String)entry.getKey());
            }
            AbstractCommand.safeRemoveCommands(map, hashSet);
            knownCommands.set(commandMap, map);
            AbstractCommand.scheduleCommandSync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void register() {
        if (!loaded) {
            list.add(this);
        } else {
            this.reg();
        }
    }

    protected void reg() {
        try {
            this.removeExistingCommand(this.command);
            ReflectCommand reflectCommand = this.createReflectCommand();
            this.configureCommand(reflectCommand);
            String string = this.plugin == null ? "minecraft" : this.plugin.getName();
            boolean bl = commandMap.register(string, (Command)reflectCommand);
            if (bl) {
                reflectCommand.setExecutor(this);
                AbstractCommand.scheduleCommandSync();
            } else {
                System.err.println("[AbstractCommand] Failed to register command: " + this.command);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ReflectCommand createReflectCommand() {
        if (this.plugin != null) {
            try {
                return new PluginReflectCommand(this.command, this.plugin);
            }
            catch (Exception exception) {
                return new ReflectCommand(this.command);
            }
        }
        return new ReflectCommand(this.command);
    }

    private void configureCommand(ReflectCommand reflectCommand) {
        try {
            if (this.alias != null && !this.alias.isEmpty()) {
                reflectCommand.setAliases(new ArrayList<String>(this.alias));
            }
            if (this.description != null) {
                reflectCommand.setDescription(this.description);
            }
            if (this.usage != null) {
                reflectCommand.setUsage(this.usage);
            }
            if (this.permMessage != null) {
                reflectCommand.setPermissionMessage(this.permMessage);
            }
            if (this.permission != null) {
                reflectCommand.setPermission(this.permission);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeExistingCommand(String string) {
        try {
            Map map = (Map)knownCommands.get(commandMap);
            if (map == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = this.plugin != null ? this.plugin.getName().toLowerCase() + ":" : "";
            for (Object object : map.keySet()) {
                if (!((String)object).equals(string) && !((String)object).equals(string.toLowerCase()) && !((String)object).equals(string2 + string) && !((String)object).equals("minecraft:" + string)) continue;
                hashSet.add((String)object);
            }
            Command command = (Command)map.get(string);
            if (command != null && command.getAliases() != null) {
                for (String string3 : command.getAliases()) {
                    hashSet.add(string3);
                    hashSet.add(string2 + string3);
                    hashSet.add("minecraft:" + string3);
                }
            }
            AbstractCommand.safeRemoveCommands(map, hashSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void safeRemoveCommands(Map<String, Command> map, Set<String> set) {
        try {
            for (String string : set) {
                try {
                    map.remove(string);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    break;
                }
            }
        }
        catch (Exception exception) {
            try {
                Map<String, Command> map2 = AbstractCommand.createNewCommandMap(map, set);
                map.clear();
                map.putAll(map2);
            }
            catch (Exception exception2) {
                AbstractCommand.forceRemoveCommands(map, set);
            }
        }
    }

    private static Map<String, Command> createNewCommandMap(Map<String, Command> map, Set<String> set) {
        HashMap<String, Command> hashMap = new HashMap<String, Command>();
        for (Map.Entry<String, Command> entry : map.entrySet()) {
            if (set.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return hashMap;
    }

    private static void forceRemoveCommands(Map<String, Command> map, Set<String> set) {
        try {
            Field[] fieldArray;
            for (Field field : fieldArray = map.getClass().getDeclaredFields()) {
                if (!Map.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Map map2 = (Map)field.get(map);
                if (map2 == null || map2 == map) continue;
                for (String string : set) {
                    try {
                        map2.remove(string);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("[AbstractCommand] Could not remove commands: " + String.valueOf(set));
        }
    }

    private static void scheduleCommandSync() {
        Plugin plugin = AbstractCommand.getAnyPlugin();
        if (plugin != null) {
            Bukkit.getScheduler().runTaskLater(plugin, () -> AbstractCommand.syncCommandsToAllPlayers(), 1L);
        } else {
            AbstractCommand.syncCommandsToAllPlayers();
        }
    }

    private static void syncCommandsToAllPlayers() {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        try {
            for (Player player : Bukkit.getOnlinePlayers()) {
                AbstractCommand.syncCommandsToPlayer(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void syncCommandsToPlayer(Player player) {
        if (AbstractCommand.tryModernSync(player)) {
            return;
        }
        if (isPaper && AbstractCommand.tryPaperSync(player)) {
            return;
        }
        if (isSpigot && AbstractCommand.trySpigotSync(player)) {
            return;
        }
        AbstractCommand.tryLegacySync(player);
    }

    private static boolean tryModernSync(Player player) {
        try {
            Method method = player.getClass().getMethod("updateCommands", new Class[0]);
            method.invoke((Object)player, new Object[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean tryPaperSync(Player player) {
        try {
            Class<?> clazz = Class.forName("com.destroystokyo.paper.entity.CraftPlayer");
            if (clazz.isInstance(player)) {
                Method method = clazz.getMethod("updateCommands", new Class[0]);
                method.invoke((Object)player, new Object[0]);
                return true;
            }
        }
        catch (Exception exception) {
            try {
                Method method = player.getClass().getMethod("updateCommands", new Class[0]);
                method.invoke((Object)player, new Object[0]);
                return true;
            }
            catch (Exception exception2) {
                return false;
            }
        }
        return false;
    }

    private static boolean trySpigotSync(Player player) {
        try {
            Method method = player.getClass().getMethod("sendCommands", new Class[0]);
            method.invoke((Object)player, new Object[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void tryLegacySync(Player player) {
        try {
            if (majorVersion >= 1 && minorVersion >= 13) {
                try {
                    player.updateCommands();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static Field getKnownCommands() {
        String string = "knownCommands";
        if (fieldCache.containsKey(string)) {
            return fieldCache.get(string);
        }
        try {
            Field field;
            Class<?> clazz = commandMap.getClass();
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("MockCommandMap", "CraftCommandMap", "FakeSimpleCommandMap", "PaperCommandMap", "SpigotCommandMap", "SimpleCommandMap"));
            if (hashSet.contains(clazz.getSimpleName())) {
                clazz = clazz.getSuperclass();
            }
            if ((field = AbstractCommand.findKnownCommandsField(clazz)) != null) {
                fieldCache.put(string, field);
            }
            return field;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Field findKnownCommandsField(Class<?> clazz) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"knownCommands", "commands", "commandMap"}) {
            try {
                Field field = clazz.getDeclaredField(string);
                field.setAccessible(true);
                if (!Map.class.isAssignableFrom(field.getType())) continue;
                return field;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (clazz.getSuperclass() != null) {
            return AbstractCommand.findKnownCommandsField(clazz.getSuperclass());
        }
        return null;
    }

    protected static CommandMap getCommandMap() {
        if (cmap == null) {
            try {
                if (AbstractCommand.tryGetCommandMapModern()) {
                    return cmap;
                }
                if (AbstractCommand.tryGetCommandMapByField()) {
                    return cmap;
                }
                if (AbstractCommand.tryGetCommandMapByMethod()) {
                    return cmap;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return cmap;
    }

    private static boolean tryGetCommandMapModern() {
        try {
            Method method = Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]);
            cmap = (CommandMap)method.invoke((Object)Bukkit.getServer(), new Object[0]);
            return cmap != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean tryGetCommandMapByField() {
        try {
            String[] stringArray = new String[]{"commandMap", "cmap", "map"};
            Class<?> clazz = Bukkit.getServer().getClass();
            for (String string : stringArray) {
                try {
                    Field field = clazz.getDeclaredField(string);
                    field.setAccessible(true);
                    Object object = field.get(Bukkit.getServer());
                    if (!(object instanceof CommandMap)) continue;
                    cmap = (CommandMap)object;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static boolean tryGetCommandMapByMethod() {
        try {
            String[] stringArray = new String[]{"getCommandMap", "getCmdMap", "getMap"};
            Class<?> clazz = Bukkit.getServer().getClass();
            for (String string : stringArray) {
                try {
                    Method method = clazz.getDeclaredMethod(string, new Class[0]);
                    method.setAccessible(true);
                    Object object = method.invoke((Object)Bukkit.getServer(), new Object[0]);
                    if (!(object instanceof CommandMap)) continue;
                    cmap = (CommandMap)object;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public static void removeCommand(String string) {
        try {
            Map map = (Map)knownCommands.get(commandMap);
            if (map == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : map.keySet()) {
                if (!string2.equals(string) && !string2.endsWith(":" + string) && !string2.equals(string.toLowerCase())) continue;
                hashSet.add(string2);
            }
            AbstractCommand.safeRemoveCommands(map, hashSet);
            knownCommands.set(commandMap, map);
            AbstractCommand.scheduleCommandSync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean isPluginCommand(Command command, Plugin plugin) {
        try {
            String string = command.toString().toLowerCase();
            String string2 = plugin.getName().toLowerCase();
            return string.contains(string2) || command.getName().startsWith(string2 + ":");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkPaperServer() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("io.papermc.paper.configuration.Configuration");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
        }
    }

    private static boolean checkSpigotServer() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static Plugin getAnyPlugin() {
        try {
            Plugin[] pluginArray;
            for (Plugin plugin : pluginArray = Bukkit.getPluginManager().getPlugins()) {
                if (!plugin.isEnabled()) continue;
                return plugin;
            }
            return pluginArray.length > 0 ? pluginArray[0] : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void removeCommandOfClass(Class<? extends Command> clazz) {
        try {
            Map map = (Map)knownCommands.get(commandMap);
            if (map == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            for (Map.Entry entry : map.entrySet()) {
                if (!clazz.isAssignableFrom(((Command)entry.getValue()).getClass())) continue;
                hashSet.add((String)entry.getKey());
            }
            AbstractCommand.safeRemoveCommands(map, hashSet);
            knownCommands.set(commandMap, map);
            AbstractCommand.scheduleCommandSync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPlayer(CommandSender commandSender) {
        return commandSender instanceof Player;
    }

    public boolean isAuthorized(CommandSender commandSender, String string) {
        return commandSender.hasPermission(string);
    }

    public boolean isAuthorized(Player player, String string) {
        return player.hasPermission(string);
    }

    public boolean isAuthorized(CommandSender commandSender, Permission permission) {
        return commandSender.hasPermission(permission);
    }

    public boolean isAuthorized(Player player, Permission permission) {
        return player.hasPermission(permission);
    }

    public abstract boolean onCommand(CommandSender var1, Command var2, String var3, String[] var4);

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        return null;
    }

    public static String getServerVersion() {
        return serverVersion != null ? serverVersion : "Unknown";
    }

    public static boolean isVersionSupported(int n, int n2) {
        return majorVersion > n || majorVersion == n && minorVersion >= n2;
    }

    public static boolean isPaperServer() {
        return isPaper;
    }

    public static boolean isSpigotServer() {
        return isSpigot;
    }

    public String getCommand() {
        return this.command;
    }

    static {
        fieldCache = new ConcurrentHashMap<String, Field>();
        methodCache = new ConcurrentHashMap<String, Method>();
        classCache = new ConcurrentHashMap();
        serverVersion = null;
        majorVersion = 0;
        minorVersion = 0;
        isPaper = false;
        isSpigot = false;
        AbstractCommand.detectServerInfo();
        commandMap = AbstractCommand.getCommandMap();
        knownCommands = AbstractCommand.getKnownCommands();
        loaded = false;
        list = new ArrayList<AbstractCommand>();
    }

    private class ReflectCommand
    extends Command {
        private AbstractCommand exe;

        protected ReflectCommand(String string) {
            super(string);
            this.exe = null;
        }

        public void setExecutor(AbstractCommand abstractCommand) {
            this.exe = abstractCommand;
        }

        public boolean execute(CommandSender commandSender, String string, String[] stringArray) {
            if (this.exe != null) {
                return this.exe.onCommand(commandSender, this, string, stringArray);
            }
            return false;
        }

        public List<String> tabComplete(CommandSender commandSender, String string, String[] stringArray) {
            List<String> list;
            if (this.exe != null && (list = this.exe.onTabComplete(commandSender, this, string, stringArray)) != null) {
                return list;
            }
            return super.tabComplete(commandSender, string, stringArray);
        }
    }

    private class PluginReflectCommand
    extends ReflectCommand
    implements PluginIdentifiableCommand {
        protected Plugin plugin;

        protected PluginReflectCommand(String string, Plugin plugin) {
            super(string);
            this.plugin = plugin;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }
    }
}

