/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.hooks;

import com.dre.brewery.api.BreweryApi;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xshyo.us.theglow.libs.theAPI.hooks.ItemHook;

public class BreweryXItemHook
implements ItemHook {
    private final boolean isBreweryAvailable;

    public BreweryXItemHook() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("BreweryX");
        this.isBreweryAvailable = plugin != null && plugin.isEnabled();
    }

    @Override
    public ItemStack getItem(String ... stringArray) {
        if (stringArray.length == 0) {
            return new ItemStack(Material.STONE, 1);
        }
        if (!this.isBreweryAvailable) {
            return this.createMissingPluginItem();
        }
        try {
            String[] stringArray2 = stringArray[0].split(":");
            String string = stringArray2[0];
            int n = stringArray2.length > 1 ? this.parseQuality(stringArray2[1]) : 5;
            ItemStack itemStack = BreweryApi.createBrewItem((String)string, (int)n);
            return itemStack != null ? itemStack : new ItemStack(Material.GLASS_BOTTLE, 1);
        }
        catch (Exception exception) {
            return new ItemStack(Material.STONE, 1);
        }
    }

    @Override
    public String getPrefix() {
        return "brewery-";
    }

    @Override
    public String getPluginName() {
        return "BreweryX";
    }

    private int parseQuality(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n < 1) {
                return 1;
            }
            if (n > 10) {
                return 10;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }
}

