/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.hooks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.utilities.Utils;

public interface ItemHook {
    public ItemStack getItem(String ... var1);

    public String getPrefix();

    public String getPluginName();

    default public ItemStack createMissingPluginItem() {
        ItemStack itemStack = new ItemStack(Material.BARRIER, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Required plugin: " + this.getPluginName());
            itemMeta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "This item requires the plugin " + this.getPluginName(), String.valueOf(ChatColor.GRAY) + "Install it to use this item"));
            NamespacedKey namespacedKey = new NamespacedKey((Plugin)TheAPI.getInstance(), "missing_plugin");
            itemMeta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.BYTE, (Object)1);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    default public ItemStack getHead() {
        return new ItemStack(Material.PLAYER_HEAD, 1);
    }

    default public ItemStack getSkullByBase64EncodedTextureUrl(String string) {
        ItemStack itemStack = this.getHead().clone();
        if (string.isEmpty()) {
            return itemStack;
        }
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (skullMeta == null) {
            return itemStack;
        }
        if (Utils.getCurrentVersion() >= 1181) {
            PlayerProfile playerProfile = this.getPlayerProfile(string);
            skullMeta.setOwnerProfile(playerProfile);
            itemStack.setItemMeta((ItemMeta)skullMeta);
            return itemStack;
        }
        GameProfile gameProfile = this.getGameProfile(string);
        try {
            Field field = skullMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(skullMeta, gameProfile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            // empty catch block
        }
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }

    default public GameProfile getGameProfile(String string) {
        GameProfile gameProfile = new GameProfile(UUID.fromString("d1f53efe-c5a4-44fd-a9a6-69f7f31cf751"), "");
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
        return gameProfile;
    }

    default public PlayerProfile getPlayerProfile(String string) {
        PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)UUID.fromString("d1f53efe-c5a4-44fd-a9a6-69f7f31cf751"));
        String string2 = this.decodeSkinUrl(string);
        if (string2 == null) {
            return playerProfile;
        }
        PlayerTextures playerTextures = playerProfile.getTextures();
        try {
            playerTextures.setSkin(new URL(string2));
        }
        catch (MalformedURLException malformedURLException) {
            Bukkit.getLogger().warning("Something went horribly wrong trying to create basehead URL");
        }
        playerProfile.setTextures(playerTextures);
        return playerProfile;
    }

    default public String decodeSkinUrl(String string) {
        String string2 = new String(Base64.getDecoder().decode(string));
        JsonObject jsonObject = (JsonObject)Utils.getGson().fromJson(string2, JsonObject.class);
        JsonElement jsonElement = jsonObject.get("textures");
        if (jsonElement == null) {
            return null;
        }
        JsonElement jsonElement2 = jsonElement.getAsJsonObject().get("SKIN");
        if (jsonElement2 == null) {
            return null;
        }
        JsonElement jsonElement3 = jsonElement2.getAsJsonObject().get("url");
        return jsonElement3 == null ? null : jsonElement3.getAsString();
    }

    default public String getEncoded(String string) {
        byte[] byArray = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "https://textures.minecraft.net/texture/" + string).getBytes());
        return new String(byArray);
    }

    default public ItemStack getSkullByName(String string) {
        ItemStack itemStack = this.getHead().clone();
        if (string.isEmpty()) {
            return itemStack;
        }
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (skullMeta == null) {
            return itemStack;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)string);
        skullMeta.setOwningPlayer(offlinePlayer);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        return itemStack;
    }
}

