/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.libs.universalScheduler.foliaScheduler;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import xshyo.us.theglow.libs.theAPI.libs.universalScheduler.foliaScheduler.FoliaScheduledTask;
import xshyo.us.theglow.libs.theAPI.libs.universalScheduler.scheduling.schedulers.TaskScheduler;
import xshyo.us.theglow.libs.theAPI.libs.universalScheduler.scheduling.tasks.MyScheduledTask;

public class FoliaScheduler
implements TaskScheduler {
    final Plugin plugin;
    private final RegionScheduler regionScheduler = Bukkit.getServer().getRegionScheduler();
    private final GlobalRegionScheduler globalRegionScheduler = Bukkit.getServer().getGlobalRegionScheduler();
    private final AsyncScheduler asyncScheduler = Bukkit.getServer().getAsyncScheduler();

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isGlobalThread() {
        return Bukkit.getServer().isGlobalTickThread();
    }

    @Override
    public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    @Override
    public boolean isEntityThread(Entity entity) {
        return Bukkit.getServer().isOwnedByCurrentRegion(entity);
    }

    @Override
    public boolean isRegionThread(Location location) {
        return Bukkit.getServer().isOwnedByCurrentRegion(location);
    }

    @Override
    public MyScheduledTask runTask(Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(this.plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Runnable runnable, long l) {
        if (l <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l));
    }

    @Override
    public MyScheduledTask runTaskTimer(Runnable runnable, long l, long l2) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l, l2));
    }

    @Override
    public MyScheduledTask runTask(Plugin plugin, Runnable runnable) {
        return new FoliaScheduledTask(this.globalRegionScheduler.run(plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Plugin plugin, Runnable runnable, long l) {
        if (l <= 0L) {
            return this.runTask(plugin, runnable);
        }
        return new FoliaScheduledTask(this.globalRegionScheduler.runDelayed(plugin, scheduledTask -> runnable.run(), l));
    }

    @Override
    public MyScheduledTask runTaskTimer(Plugin plugin, Runnable runnable, long l, long l2) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.globalRegionScheduler.runAtFixedRate(plugin, scheduledTask -> runnable.run(), l, l2));
    }

    @Override
    public MyScheduledTask runTask(Location location, Runnable runnable) {
        return new FoliaScheduledTask(this.regionScheduler.run(this.plugin, location, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLater(Location location, Runnable runnable, long l) {
        if (l <= 0L) {
            return this.runTask(runnable);
        }
        return new FoliaScheduledTask(this.regionScheduler.runDelayed(this.plugin, location, scheduledTask -> runnable.run(), l));
    }

    @Override
    public MyScheduledTask runTaskTimer(Location location, Runnable runnable, long l, long l2) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.regionScheduler.runAtFixedRate(this.plugin, location, scheduledTask -> runnable.run(), l, l2));
    }

    @Override
    public MyScheduledTask runTask(Entity entity, Runnable runnable) {
        return new FoliaScheduledTask(entity.getScheduler().run(this.plugin, scheduledTask -> runnable.run(), null));
    }

    @Override
    public MyScheduledTask runTaskLater(Entity entity, Runnable runnable, long l) {
        if (l <= 0L) {
            return this.runTask(entity, runnable);
        }
        return new FoliaScheduledTask(entity.getScheduler().runDelayed(this.plugin, scheduledTask -> runnable.run(), null, l));
    }

    @Override
    public MyScheduledTask runTaskTimer(Entity entity, Runnable runnable, long l, long l2) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(entity.getScheduler().runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), null, l, l2));
    }

    @Override
    public MyScheduledTask runTaskAsynchronously(Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(this.plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLaterAsynchronously(Runnable runnable, long l) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(this.plugin, scheduledTask -> runnable.run(), l * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskTimerAsynchronously(Runnable runnable, long l, long l2) {
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(this.plugin, scheduledTask -> runnable.run(), l * 50L, l2 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskAsynchronously(Plugin plugin, Runnable runnable) {
        return new FoliaScheduledTask(this.asyncScheduler.runNow(plugin, scheduledTask -> runnable.run()));
    }

    @Override
    public MyScheduledTask runTaskLaterAsynchronously(Plugin plugin, Runnable runnable, long l) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.asyncScheduler.runDelayed(plugin, scheduledTask -> runnable.run(), l * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public MyScheduledTask runTaskTimerAsynchronously(Plugin plugin, Runnable runnable, long l, long l2) {
        l = this.getOneIfNotPositive(l);
        return new FoliaScheduledTask(this.asyncScheduler.runAtFixedRate(plugin, scheduledTask -> runnable.run(), l * 50L, l2 * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public void execute(Runnable runnable) {
        this.globalRegionScheduler.execute(this.plugin, runnable);
    }

    @Override
    public void execute(Location location, Runnable runnable) {
        this.regionScheduler.execute(this.plugin, location, runnable);
    }

    @Override
    public void execute(Entity entity, Runnable runnable) {
        entity.getScheduler().execute(this.plugin, runnable, null, 1L);
    }

    @Override
    public void cancelTasks() {
        this.globalRegionScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    public void cancelTasks(Plugin plugin) {
        this.globalRegionScheduler.cancelTasks(plugin);
        this.asyncScheduler.cancelTasks(plugin);
    }

    private long getOneIfNotPositive(long l) {
        return l <= 0L ? 1L : l;
    }
}

