/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.requirements;

import org.bukkit.entity.Player;
import xshyo.us.theglow.libs.theAPI.requirements.NumericCondition;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementCondition;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementProvider;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementResult;
import xshyo.us.theglow.libs.theAPI.requirements.TextCondition;
import xshyo.us.theglow.libs.theAPI.utilities.Utils;

public class Requirement {
    private String placeholder;
    private String condition;
    private Object value;
    private String successMessage;
    private String failMessage;

    public RequirementResult check(Player player, RequirementProvider requirementProvider) {
        String string = requirementProvider.getValue(player, this.placeholder);
        RequirementCondition requirementCondition = this.getConditionChecker(this.condition, string);
        boolean bl = requirementCondition.check(string, this.value);
        String string2 = (bl ? this.successMessage : this.failMessage).replace("{value}", String.valueOf(this.value));
        return new RequirementResult(bl, Utils.translate(string2));
    }

    private RequirementCondition getConditionChecker(String string, String string2) {
        boolean bl;
        switch (string) {
            case ">=": 
            case ">": 
            case "<=": 
            case "<": 
            case "==": 
            case "!=": {
                boolean bl2 = true;
                break;
            }
            default: {
                boolean bl2 = bl = false;
            }
        }
        if (bl && this.isNumeric(this.value) && this.isNumeric(string2)) {
            return new NumericCondition(string);
        }
        return new TextCondition(string);
    }

    private boolean isNumeric(Object object) {
        try {
            Double.parseDouble(String.valueOf(object));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public String getCondition() {
        return this.condition;
    }

    public Object getValue() {
        return this.value;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setPlaceholder(String string) {
        this.placeholder = string;
    }

    public void setCondition(String string) {
        this.condition = string;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    public void setSuccessMessage(String string) {
        this.successMessage = string;
    }

    public void setFailMessage(String string) {
        this.failMessage = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Requirement)) {
            return false;
        }
        Requirement requirement = (Requirement)object;
        if (!requirement.canEqual(this)) {
            return false;
        }
        String string = this.getPlaceholder();
        String string2 = requirement.getPlaceholder();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getCondition();
        String string4 = requirement.getCondition();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Object object2 = this.getValue();
        Object object3 = requirement.getValue();
        if (object2 == null ? object3 != null : !object2.equals(object3)) {
            return false;
        }
        String string5 = this.getSuccessMessage();
        String string6 = requirement.getSuccessMessage();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getFailMessage();
        String string8 = requirement.getFailMessage();
        return !(string7 == null ? string8 != null : !string7.equals(string8));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Requirement;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        String string = this.getPlaceholder();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getCondition();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Object object = this.getValue();
        n2 = n2 * 59 + (object == null ? 43 : object.hashCode());
        String string3 = this.getSuccessMessage();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getFailMessage();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        return n2;
    }

    public String toString() {
        return "Requirement(placeholder=" + this.getPlaceholder() + ", condition=" + this.getCondition() + ", value=" + String.valueOf(this.getValue()) + ", successMessage=" + this.getSuccessMessage() + ", failMessage=" + this.getFailMessage() + ")";
    }

    public Requirement(String string, String string2, Object object, String string3, String string4) {
        this.placeholder = string;
        this.condition = string2;
        this.value = object;
        this.successMessage = string3;
        this.failMessage = string4;
    }
}

