/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.requirements;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xshyo.us.theglow.libs.theAPI.requirements.PlaceholderAPIProvider;
import xshyo.us.theglow.libs.theAPI.requirements.Requirement;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementProvider;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementResult;

public class RequirementManager {
    private final Map<String, RequirementProvider> providers = new HashMap<String, RequirementProvider>();

    public RequirementManager() {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.registerProvider("placeholderapi", new PlaceholderAPIProvider());
        }
    }

    public void registerProvider(String string, RequirementProvider requirementProvider) {
        this.providers.put(string.toLowerCase(), requirementProvider);
    }

    public List<RequirementResult> checkRequirements(Player player, List<Requirement> list) {
        RequirementProvider requirementProvider = this.getDefaultProvider();
        if (requirementProvider == null) {
            return list.stream().map(requirement -> new RequirementResult(false, "&c[!] Missing requirement provider: PlaceholderAPI")).collect(Collectors.toList());
        }
        return list.stream().map(requirement -> requirement.check(player, requirementProvider)).collect(Collectors.toList());
    }

    private RequirementProvider getDefaultProvider() {
        return this.providers.get("placeholderapi");
    }

    public Map<String, RequirementProvider> getProviders() {
        return this.providers;
    }
}

