/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.utilities;

import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xshyo.us.theglow.libs.theAPI.TheAPI;
import xshyo.us.theglow.libs.theAPI.requirements.Requirement;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementManager;
import xshyo.us.theglow.libs.theAPI.requirements.RequirementResult;

public final class Utils {
    private static final Random random = new Random();
    private static final Gson gson;
    public static final Pattern HEX_PATTERN;
    public static int[] targetSlots;

    public static boolean isLocked(List<Map<String, Object>> list, Player player) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        try {
            ArrayList<Requirement> arrayList = new ArrayList<Requirement>();
            for (Map<String, Object> map : list) {
                Map<String, Object> map2;
                Requirement requirement;
                if (!(map instanceof Map) || (requirement = Utils.createRequirement(map2 = map)) == null) continue;
                arrayList.add(requirement);
            }
            if (arrayList.isEmpty()) {
                return true;
            }
            List<RequirementResult> list2 = TheAPI.getInstance().getRequirementManager().checkRequirements(player, arrayList);
            return list2.stream().allMatch(RequirementResult::isMeets);
        }
        catch (Exception exception) {
            TheAPI.getInstance().getLogger().warning("Error when verifying requirements: " + exception.getMessage());
            return false;
        }
    }

    public static List<String> getRequirementsLore(List<Map<String, Object>> list, Player player, boolean bl, boolean bl2, String string) {
        if (list == null) {
            return new ArrayList<String>();
        }
        string = Utils.translate(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Requirement> list2 = list.stream().map(Utils::createRequirement).collect(Collectors.toList());
        RequirementManager requirementManager = TheAPI.getInstance().getRequirementManager();
        if (requirementManager.getProviders() == null) {
            arrayList.add(Utils.translate("&c[!] Requirement system is not available."));
            arrayList.add(Utils.translate("&7Please install &ePlaceholderAPI &7or remove this requirement."));
            return arrayList;
        }
        List<RequirementResult> list3 = requirementManager.checkRequirements(player, list2);
        boolean bl3 = false;
        for (RequirementResult requirementResult : list3) {
            String string2 = requirementResult.getMessage();
            if (bl && (string2 == null || string2.trim().isEmpty())) continue;
            if (bl2 && bl3) {
                arrayList.add(string);
                continue;
            }
            arrayList.add(Utils.setPAPI(player, string2));
            if (requirementResult.isMeets()) continue;
            bl3 = true;
        }
        return arrayList;
    }

    public static Requirement createRequirement(Map<String, Object> map) {
        return new Requirement((String)map.get("placeholder"), (String)map.get("condition"), map.get("value"), (String)map.get("success"), (String)map.get("fail"));
    }

    public static boolean hasPermission(CommandSender commandSender, String string, String string2, String string3, String string4) {
        if (commandSender.isOp() || commandSender.hasPermission(string3) || commandSender.hasPermission(string4)) {
            return true;
        }
        commandSender.sendMessage(Utils.translate(string.replace("{1}", commandSender.getName()).replace("{2}", string3)));
        Bukkit.getConsoleSender().sendMessage(Utils.translate(string2.replace("{1}", commandSender.getName()).replace("{2}", string3)));
        return false;
    }

    public static void sendRawMessage(Player player, String string, String string2, String string3, Object ... objectArray) {
        if (string != null && !string.isEmpty()) {
            if (objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = "{" + (i + 1) + "}";
                    string = string.replace(string4, objectArray[i].toString());
                }
            }
            string = string.replace("{cmd}", string2);
            string = string.replace("{shortenedcmd}", string3);
            player.sendRawMessage(Utils.translate(string));
        }
    }

    public static void sendMessage(CommandSender commandSender, String string, String string2, String string3, Object ... objectArray) {
        if (string != null && !string.isEmpty()) {
            if (objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = "{" + (i + 1) + "}";
                    string = string.replace(string4, objectArray[i].toString());
                }
            }
            string = string.replace("{cmd}", string2);
            string = string.replace("{shortenedcmd}", string3);
            commandSender.sendMessage(Utils.translate(string));
        }
    }

    public static void sendMessageWhitPath(CommandSender commandSender, String string, String string2, String string3, Object ... objectArray) {
        if (string != null && !string.isEmpty()) {
            if (objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = "{" + (i + 1) + "}";
                    string = string.replace(string4, objectArray[i].toString());
                }
            }
            string = string.replace("{cmd}", string2);
            string = string.replace("{shortenedcmd}", string3);
            commandSender.sendMessage(Utils.translate(string));
        }
    }

    public static boolean passCondition(Player player, String string) {
        String[] stringArray = string.split(" ");
        String string2 = Utils.setPAPI(player, stringArray[0]);
        String string3 = stringArray[1];
        try {
            double d = Double.parseDouble(stringArray[2]);
            double d2 = Double.parseDouble(string2);
            switch (string3) {
                case ">=": {
                    return d2 >= d;
                }
                case "<=": {
                    return d2 <= d;
                }
                case "==": {
                    return string2.equals(stringArray[2]);
                }
                case "!=": {
                    return !string2.equals(stringArray[2]);
                }
                case ">": {
                    return d2 > d;
                }
                case "<": {
                    return d2 < d;
                }
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
            switch (stringArray[1]) {
                case "<-": {
                    return string2.contains(stringArray[2]);
                }
                case "!=": {
                    return !string2.equals(stringArray[2]);
                }
                case "=": {
                    return string2.equals(stringArray[2]);
                }
                case "|-": {
                    return string2.startsWith(stringArray[2]);
                }
                case "-|": {
                    return string2.endsWith(stringArray[2]);
                }
            }
            return false;
        }
    }

    public static void sendMessageWhitPath(CommandSender commandSender, String string, Object ... objectArray) {
        if (string != null && !string.isEmpty()) {
            if (objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = "{" + (i + 1) + "}";
                    string = string.replace(string2, objectArray[i].toString());
                }
            }
            commandSender.sendMessage(Utils.translate(string));
        }
    }

    public static void sendActionbar(Player player, String string) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Utils.setPAPI(player, string)));
    }

    public static boolean shouldExecuteAction(String string) {
        int n = Integer.parseInt(string.substring(8, string.length() - 1));
        return random.nextInt(100) < n;
    }

    public static String removeHexFormats(String string) {
        return HEX_PATTERN.matcher(string).replaceAll("");
    }

    private static String translateHexColorCodes(String string) {
        int n = 167;
        Matcher matcher = HEX_PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length() + 32);
        while (matcher.find()) {
            String string2 = matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
            matcher.appendReplacement(stringBuffer, "\u00a7x\u00a7" + string2.charAt(0) + "\u00a7" + string2.charAt(1) + "\u00a7" + string2.charAt(2) + "\u00a7" + string2.charAt(3) + "\u00a7" + string2.charAt(4) + "\u00a7" + string2.charAt(5));
        }
        return matcher.appendTail(stringBuffer).toString();
    }

    public static String colorize(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static String translate(String string) {
        return Utils.translateHexColorCodes(Utils.colorize(string));
    }

    public static String[] translate(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Utils.translate(stringArray[i]);
        }
        return stringArray;
    }

    public static List<String> translate(List<String> list) {
        return list.stream().map(Utils::translate).collect(Collectors.toList());
    }

    public static String setPAPI(Player player, String string) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        return string;
    }

    public static int getCurrentVersion() {
        Object object;
        Matcher matcher = Pattern.compile("(?<version>\\d+\\.\\d+)(?<patch>\\.\\d+)?").matcher(Bukkit.getBukkitVersion());
        StringBuilder stringBuilder = new StringBuilder();
        if (matcher.find()) {
            stringBuilder.append(matcher.group("version").replace(".", ""));
            object = matcher.group("patch");
            if (object == null) {
                stringBuilder.append("0");
            } else {
                stringBuilder.append(((String)object).replace(".", ""));
            }
        }
        if ((object = Ints.tryParse((String)stringBuilder.toString())) == null) {
            throw new RuntimeException("Could not retrieve server version!");
        }
        return (Integer)object;
    }

    public static String millisToLongDHMS(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if (l >= 1000L) {
            long l2 = l / 86400000L;
            if (l2 > 0L) {
                bl = true;
                l -= l2 * 86400000L;
                stringBuilder.append(l2).append("d");
            }
            if (bl) {
                stringBuilder.append(" ");
                bl = false;
            }
            if ((l2 = l / 3600000L) > 0L) {
                bl = true;
                l -= l2 * 3600000L;
                stringBuilder.append(l2).append("h");
            }
            if (bl) {
                stringBuilder.append(" ");
                bl = false;
            }
            if ((l2 = l / 60000L) > 0L) {
                bl = true;
                l -= l2 * 60000L;
                stringBuilder.append(l2).append("m");
            }
            if ((l2 = l / 1000L) > 0L) {
                if (bl) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(l2).append(l2 > 1L ? "s" : "");
            }
            return stringBuilder.toString();
        }
        return "0";
    }

    public static void createPrompt(JavaPlugin javaPlugin, Player player, boolean bl, int n, StringPrompt stringPrompt, Map<Object, Object> map) {
        Conversation conversation = new ConversationFactory((Plugin)javaPlugin).withFirstPrompt((Prompt)stringPrompt).withInitialSessionData(map).withLocalEcho(bl).withTimeout(n).buildConversation((Conversable)player);
        conversation.begin();
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Gson getGson() {
        return gson;
    }

    static {
        HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})|#([A-Fa-f0-9]{6})");
        targetSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        gson = new Gson();
    }
}

