/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.theAPI.utilities.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.AxolotlBucketMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MusicInstrumentMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import xshyo.us.theglow.libs.theAPI.hooks.BaseHeadHook;
import xshyo.us.theglow.libs.theAPI.hooks.BreweryXItemHook;
import xshyo.us.theglow.libs.theAPI.hooks.ExecutableBlocksHook;
import xshyo.us.theglow.libs.theAPI.hooks.ExecutableItemsHook;
import xshyo.us.theglow.libs.theAPI.hooks.HeadDataBaseHook;
import xshyo.us.theglow.libs.theAPI.hooks.ItemHook;
import xshyo.us.theglow.libs.theAPI.hooks.ItemsAdderHook;
import xshyo.us.theglow.libs.theAPI.hooks.MMOItemsHook;
import xshyo.us.theglow.libs.theAPI.hooks.MythicMobsHook;
import xshyo.us.theglow.libs.theAPI.hooks.NamedHeadHook;
import xshyo.us.theglow.libs.theAPI.hooks.OraxenHook;
import xshyo.us.theglow.libs.theAPI.hooks.QualityArmoryHook;
import xshyo.us.theglow.libs.theAPI.hooks.TextureHeadHook;
import xshyo.us.theglow.libs.theAPI.utilities.Utils;

public class ItemBuilder {
    private final ItemStack itemStack;
    private ItemMeta itemMeta;
    private static final List<ItemHook> HANDLERS = Arrays.asList(new BaseHeadHook(), new HeadDataBaseHook(), new ItemsAdderHook(), new NamedHeadHook(), new MMOItemsHook(), new ExecutableBlocksHook(), new ExecutableItemsHook(), new BreweryXItemHook(), new OraxenHook(), new TextureHeadHook(), new QualityArmoryHook(), new MythicMobsHook());

    public ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.itemMeta = itemStack.getItemMeta();
    }

    public ItemBuilder(Material material) {
        this.itemStack = new ItemStack(material, 1);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(Material material, int n) {
        this.itemStack = new ItemStack(material, n);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(String string) {
        ItemHook itemHook = this.getHandlerForPrefix(string);
        if (itemHook != null) {
            this.itemStack = itemHook.getItem(string.substring(itemHook.getPrefix().length()));
        } else {
            Material material = Material.matchMaterial((String)string);
            this.itemStack = new ItemStack(Objects.requireNonNullElse(material, Material.STONE), 1);
        }
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder(String string, int n) {
        ItemHook itemHook = this.getHandlerForPrefix(string);
        if (itemHook != null) {
            this.itemStack = itemHook.getItem(string.substring(itemHook.getPrefix().length()));
            this.itemStack.setAmount(n);
        } else {
            Material material = Material.matchMaterial((String)string);
            this.itemStack = new ItemStack(Objects.requireNonNullElse(material, Material.STONE), n);
        }
        this.itemMeta = this.itemStack.getItemMeta();
    }

    private ItemHook getHandlerForPrefix(String string) {
        for (ItemHook itemHook : HANDLERS) {
            if (!string.startsWith(itemHook.getPrefix())) continue;
            return itemHook;
        }
        return null;
    }

    public ItemBuilder(Material material, int n, int n2) {
        this.itemStack = new ItemStack(material, n, (short)n2);
        this.itemMeta = this.itemStack.getItemMeta();
    }

    public ItemBuilder setData(int n) {
        this.itemStack.setDurability((short)n);
        return this;
    }

    public ItemBuilder setAmount(int n) {
        this.itemStack.setAmount(n);
        return this;
    }

    public ItemBuilder addAmount(int n) {
        this.itemStack.setAmount(this.itemStack.getAmount() + n);
        return this;
    }

    public ItemBuilder setName(String string) {
        if (this.itemMeta != null) {
            this.itemMeta.setDisplayName(Utils.translate(string));
        }
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        if (string == null || string.isEmpty() || this.itemMeta == null) {
            return this;
        }
        if (this.itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)this.itemMeta;
            skullMeta.setOwner(string);
        }
        return this;
    }

    public ItemBuilder setSkullOwnerOffline(OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null || this.itemMeta == null) {
            return this;
        }
        if (!this.itemStack.getType().toString().endsWith("SKULL_ITEM") && !this.itemStack.getType().toString().endsWith("PLAYER_HEAD")) {
            return this;
        }
        try {
            if (!(this.itemMeta instanceof SkullMeta)) {
                return this;
            }
            SkullMeta skullMeta = (SkullMeta)this.itemMeta;
            skullMeta.setOwningPlayer(offlinePlayer);
            this.itemMeta = skullMeta;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return this;
    }

    public ItemBuilder setNBTData(String string) {
        if (string == null || string.isEmpty() || this.itemMeta == null) {
            return this;
        }
        return this;
    }

    public ItemBuilder addNBTData(String string) {
        if (string == null || string.isEmpty()) {
            return this;
        }
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        if (this.itemMeta != null) {
            this.itemMeta.setLore(Utils.translate(list));
        }
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        if (this.itemMeta != null) {
            this.itemMeta.setLore(Utils.translate(Arrays.asList(stringArray)));
        }
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        if (this.itemMeta != null) {
            ArrayList<String> arrayList = this.itemMeta.getLore();
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(Utils.translate(string));
            this.itemMeta.setLore(arrayList);
        }
        return this;
    }

    public ItemBuilder setEnchanted(boolean bl) {
        if (bl && this.itemMeta != null) {
            this.itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
            this.itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.itemStack.setItemMeta(this.itemMeta);
        }
        return this;
    }

    public ItemBuilder addEnchantment() {
        try {
            if (this.itemMeta != null) {
                this.itemMeta.addEnchant(Enchantment.DURABILITY, 1, false);
                this.itemStack.setItemMeta(this.itemMeta);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Error when adding enchantment: " + illegalArgumentException.getMessage());
        }
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int n) {
        try {
            if (this.itemMeta != null) {
                this.itemMeta.addEnchant(enchantment, n, false);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("Error when adding enchantment " + String.valueOf(enchantment.getKey()) + ": " + illegalArgumentException.getMessage());
        }
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        try {
            this.itemMeta.addEnchant(enchantment, n, true);
        }
        catch (Exception exception) {
            System.out.println("Error adding unsafe enchantment " + String.valueOf(enchantment.getKey()) + ": " + exception.getMessage());
        }
        return this;
    }

    public boolean hasCustomModelData() {
        return this.itemMeta != null && this.itemMeta.hasCustomModelData();
    }

    public ItemBuilder setCustomModelData(int n) {
        if (this.itemMeta != null && !this.itemMeta.hasCustomModelData()) {
            this.itemMeta.setCustomModelData(Integer.valueOf(n));
        }
        return this;
    }

    public ItemBuilder setShieldPattern(DyeColor dyeColor, List<Pattern> list) {
        if (this.itemStack.getType() != Material.SHIELD || this.itemMeta == null) {
            return this;
        }
        try {
            BlockStateMeta blockStateMeta = (BlockStateMeta)this.itemMeta;
            Banner banner = (Banner)blockStateMeta.getBlockState();
            if (dyeColor != null) {
                banner.setBaseColor(dyeColor);
            }
            if (list != null && !list.isEmpty()) {
                banner.setPatterns(list);
            }
            banner.update();
            blockStateMeta.setBlockState((BlockState)banner);
            this.itemMeta = blockStateMeta;
        }
        catch (Exception exception) {
            System.out.println("Error applying shield pattern: " + exception.getMessage());
        }
        return this;
    }

    public ItemBuilder setShieldFromJson(String string) {
        if (string == null || string.isEmpty() || this.itemMeta == null || this.itemStack.getType() != Material.SHIELD) {
            return this;
        }
        try {
            BlockStateMeta blockStateMeta = (BlockStateMeta)this.itemMeta;
            Banner banner = (Banner)blockStateMeta.getBlockState();
            JsonObject jsonObject = (JsonObject)Utils.getGson().fromJson(string, JsonObject.class);
            JsonObject jsonObject2 = jsonObject.getAsJsonObject("BlockEntityTag");
            if (jsonObject2 != null) {
                JsonArray jsonArray;
                int n;
                Object object;
                if (jsonObject2.has("Base") && (object = DyeColor.getByDyeData((byte)((byte)(n = jsonObject2.get("Base").getAsInt())))) != null) {
                    banner.setBaseColor((DyeColor)object);
                }
                if ((jsonArray = jsonObject2.getAsJsonArray("Patterns")) != null) {
                    object = new ArrayList();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonObject jsonObject3 = jsonArray.get(i).getAsJsonObject();
                        int n2 = jsonObject3.get("Color").getAsInt();
                        String string2 = jsonObject3.get("Pattern").getAsString();
                        DyeColor dyeColor = DyeColor.getByDyeData((byte)((byte)n2));
                        PatternType patternType = PatternType.getByIdentifier((String)string2);
                        if (dyeColor == null || patternType == null) continue;
                        Pattern pattern = new Pattern(dyeColor, patternType);
                        object.add(pattern);
                    }
                    banner.setPatterns((List)object);
                }
            }
            banner.update();
            blockStateMeta.setBlockState((BlockState)banner);
            this.itemMeta = blockStateMeta;
        }
        catch (Exception exception) {
            System.out.println("Error processing shield JSON: " + exception.getMessage());
        }
        return this;
    }

    public ItemBuilder setBannerFromJson(String string) {
        if (string == null || string.isEmpty() || this.itemMeta == null) {
            return this;
        }
        if (this.itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
            try {
                JsonArray jsonArray;
                JsonObject jsonObject = (JsonObject)Utils.getGson().fromJson(string, JsonObject.class);
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("BlockEntityTag");
                if (jsonObject2 != null && (jsonArray = jsonObject2.getAsJsonArray("Patterns")) != null) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JsonObject jsonObject3 = jsonArray.get(i).getAsJsonObject();
                        int n = jsonObject3.get("Color").getAsInt();
                        String string2 = jsonObject3.get("Pattern").getAsString();
                        DyeColor dyeColor = DyeColor.getByDyeData((byte)((byte)n));
                        PatternType patternType = PatternType.getByIdentifier((String)string2);
                        if (dyeColor == null || patternType == null) continue;
                        Pattern pattern = new Pattern(dyeColor, patternType);
                        bannerMeta.addPattern(pattern);
                    }
                }
                this.itemMeta = bannerMeta;
            }
            catch (Exception exception) {
                System.out.println("Error processing banner JSON: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder addFlagsFromConfig(Set<String> set) {
        if (set != null && !set.isEmpty() && this.itemMeta != null) {
            boolean bl = false;
            for (String string : set) {
                try {
                    ItemFlag itemFlag = ItemFlag.valueOf((String)string.toUpperCase());
                    if (itemFlag == ItemFlag.HIDE_ATTRIBUTES && Utils.getCurrentVersion() >= 1206 && !bl) {
                        this.itemMeta.setAttributeModifiers((Multimap)ImmutableMultimap.of());
                        bl = true;
                    }
                    this.itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("Warning: Invalid ItemFlag found in configuration: " + string);
                }
            }
        }
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag itemFlag) {
        if (this.itemMeta != null) {
            this.itemMeta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        return this;
    }

    public ItemBuilder setGoatHornData(MusicInstrument musicInstrument) {
        if (this.itemStack.getType() == Material.GOAT_HORN && musicInstrument != null) {
            try {
                if (this.itemMeta instanceof MusicInstrumentMeta) {
                    MusicInstrumentMeta musicInstrumentMeta = (MusicInstrumentMeta)this.itemMeta;
                    musicInstrumentMeta.setInstrument(musicInstrument);
                    this.itemStack.setItemMeta((ItemMeta)musicInstrumentMeta);
                } else {
                    System.out.println("Instrumento no encontrado o tipo de ItemMeta incorrecto.");
                }
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder setGoatHornData(NamespacedKey namespacedKey) {
        if (this.itemStack.getType() == Material.GOAT_HORN && namespacedKey != null) {
            try {
                ItemMeta itemMeta = this.itemMeta;
                if (itemMeta instanceof MusicInstrumentMeta) {
                    MusicInstrumentMeta musicInstrumentMeta = (MusicInstrumentMeta)itemMeta;
                    musicInstrumentMeta.setInstrument(MusicInstrument.getByKey((NamespacedKey)namespacedKey));
                    this.itemStack.setItemMeta((ItemMeta)musicInstrumentMeta);
                } else {
                    System.out.println("Instrumento no encontrado o tipo de ItemMeta incorrecto.");
                }
            }
            catch (Exception exception) {
                System.out.println("Error setting goat horn with NamespacedKey: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder setGoatHornData(String string) {
        if (this.itemStack.getType() == Material.GOAT_HORN && string != null) {
            try {
                if (Utils.getCurrentVersion() >= 1201) {
                    MusicInstrument musicInstrument = (MusicInstrument)Registry.INSTRUMENT.get(NamespacedKey.minecraft((String)string.toLowerCase()));
                    if (musicInstrument != null) {
                        return this.setGoatHornData(musicInstrument);
                    }
                } else {
                    NamespacedKey namespacedKey = NamespacedKey.minecraft((String)string.toLowerCase());
                    return this.setGoatHornData(namespacedKey);
                }
                System.out.println("Invalid music instrument: " + string);
            }
            catch (Exception exception) {
                System.out.println("Error setting goat horn data: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder setLeatherArmorColor(String string) {
        if (this.itemMeta == null) {
            return this;
        }
        if (this.itemStack.getType() == Material.LEATHER_HELMET || this.itemStack.getType() == Material.LEATHER_CHESTPLATE || this.itemStack.getType() == Material.LEATHER_LEGGINGS || this.itemStack.getType() == Material.LEATHER_BOOTS) {
            try {
                Object object;
                LeatherArmorMeta leatherArmorMeta;
                int n = 160;
                int n2 = 101;
                int n3 = 64;
                if (string != null && string.length() > 2 && ((LeatherArmorMeta)(leatherArmorMeta = ((String)(object = string.replaceAll("\\s+", ""))).split(","))).length >= 3) {
                    n = Integer.parseInt((String)leatherArmorMeta[0]);
                    n2 = Integer.parseInt((String)leatherArmorMeta[1]);
                    n3 = Integer.parseInt((String)leatherArmorMeta[2]);
                }
                object = Color.fromRGB((int)n, (int)n2, (int)n3);
                if (this.itemMeta instanceof LeatherArmorMeta) {
                    leatherArmorMeta = (LeatherArmorMeta)this.itemMeta;
                    leatherArmorMeta.setColor((Color)object);
                    this.itemMeta = leatherArmorMeta;
                }
            }
            catch (Exception exception) {
                System.out.println("Error when setting the color of the armor: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder setBasePotionData(PotionData potionData) {
        if (this.itemMeta != null && this.itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)this.itemMeta;
            potionMeta.setBasePotionData(potionData);
            this.itemMeta = potionMeta;
        }
        return this;
    }

    public ItemBuilder addCustomEffect(PotionEffect potionEffect, boolean bl) {
        if (this.itemMeta != null && this.itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)this.itemMeta;
            potionMeta.addCustomEffect(potionEffect, bl);
            this.itemMeta = potionMeta;
        }
        return this;
    }

    public ItemBuilder setBannerBaseColor(DyeColor dyeColor) {
        if (this.itemMeta != null && this.itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
            try {
                bannerMeta.setBaseColor(dyeColor);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                System.out.println("setBaseColor is not available in this version.");
            }
            this.itemMeta = bannerMeta;
        }
        return this;
    }

    public ItemBuilder addBannerPattern(Pattern pattern) {
        if (this.itemMeta != null && this.itemMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)this.itemMeta;
            bannerMeta.addPattern(pattern);
            this.itemMeta = bannerMeta;
        }
        return this;
    }

    public ItemBuilder setFireworkPower(int n) {
        if (this.itemMeta != null && this.itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)this.itemMeta;
            fireworkMeta.setPower(n);
            this.itemMeta = fireworkMeta;
        }
        return this;
    }

    public ItemBuilder addFireworkEffect(FireworkEffect fireworkEffect) {
        if (this.itemMeta != null && this.itemMeta instanceof FireworkMeta) {
            FireworkMeta fireworkMeta = (FireworkMeta)this.itemMeta;
            fireworkMeta.addEffect(fireworkEffect);
            this.itemMeta = fireworkMeta;
        }
        return this;
    }

    public ItemBuilder setAxolotlVariant(Axolotl.Variant variant) {
        if (this.itemMeta != null && this.itemMeta instanceof AxolotlBucketMeta) {
            AxolotlBucketMeta axolotlBucketMeta = (AxolotlBucketMeta)this.itemMeta;
            axolotlBucketMeta.setVariant(variant);
            this.itemMeta = axolotlBucketMeta;
        }
        return this;
    }

    public ItemBuilder setChargedProjectiles(List<ItemStack> list) {
        if (this.itemMeta != null && this.itemMeta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)this.itemMeta;
            crossbowMeta.setChargedProjectiles(list);
            this.itemMeta = crossbowMeta;
        }
        return this;
    }

    public ItemBuilder setSpawnerType(String string) {
        if (string == null || string.isEmpty() || this.itemMeta == null) {
            return this;
        }
        if (this.itemStack.getType().name().equals("SPAWNER") || this.itemStack.getType().name().equals("MOB_SPAWNER")) {
            try {
                BlockStateMeta blockStateMeta;
                if (this.itemMeta instanceof BlockStateMeta && (blockStateMeta = (BlockStateMeta)this.itemMeta).getBlockState() instanceof CreatureSpawner) {
                    CreatureSpawner creatureSpawner = (CreatureSpawner)blockStateMeta.getBlockState();
                    try {
                        EntityType entityType = EntityType.valueOf((String)string.toUpperCase());
                        creatureSpawner.setSpawnedType(entityType);
                        blockStateMeta.setBlockState((BlockState)creatureSpawner);
                        this.itemMeta = blockStateMeta;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println("Invalid entity type: " + string);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error when setting spawner type: " + exception.getMessage());
            }
        }
        return this;
    }

    public ItemBuilder setArmorTrim(ArmorTrim armorTrim) {
        if (this.itemMeta == null) {
            return this;
        }
        if (Utils.getCurrentVersion() >= 1200) {
            try {
                if ((this.itemStack.getType().name().contains("_HELMET") || this.itemStack.getType().name().contains("_CHESTPLATE") || this.itemStack.getType().name().contains("_LEGGINGS") || this.itemStack.getType().name().contains("_BOOTS")) && this.itemMeta instanceof ArmorMeta) {
                    ArmorMeta armorMeta = (ArmorMeta)this.itemMeta;
                    armorMeta.setTrim(armorTrim);
                    this.itemMeta = armorMeta;
                }
            }
            catch (Exception | NoClassDefFoundError throwable) {
                System.out.println("Error when setting armor trim (compatible Minecraft version?): " + throwable.getMessage());
            }
        }
        return this;
    }

    public ItemStack build() {
        if (this.itemMeta != null) {
            this.itemStack.setItemMeta(this.itemMeta);
        }
        return this.itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemMeta getItemMeta() {
        return this.itemMeta;
    }
}

