/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.zapper.DependencyDownloadResult;
import xshyo.us.theglow.libs.zapper.repository.Repository;

public final class Dependency {
    private static final String MAVEN_PATH = "%s/%s/%s/%s-%s%s";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String mavenPath;

    public Dependency(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        this(string, string2, string3, null);
    }

    public Dependency(@NotNull String string, @NotNull String string2, @NotNull String string3, @Nullable String string4) {
        this.groupId = string;
        this.artifactId = string2;
        this.version = string3;
        this.mavenPath = String.format(MAVEN_PATH, this.groupId.replace('.', '/'), this.artifactId, this.version, this.artifactId, this.version, string4 == null || StringUtils.isBlank((String)string4) ? "" : '-' + string4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return Objects.equals(this.groupId, dependency.groupId) && Objects.equals(this.artifactId, dependency.artifactId) && Objects.equals(this.version, dependency.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }

    @CheckReturnValue
    @NotNull
    public DependencyDownloadResult download(@NotNull File file, @NotNull Repository repository) {
        try {
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            URL uRL = repository.resolve(this);
            try (InputStream inputStream = uRL.openStream();
                 OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                int n;
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            return DependencyDownloadResult.success();
        }
        catch (Throwable throwable) {
            file.delete();
            return DependencyDownloadResult.failure(throwable);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMavenPath() {
        return this.mavenPath;
    }

    public String toString() {
        return "Dependency{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", mavenPath='" + this.mavenPath + '\'' + '}';
    }
}

