/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface DependencyDownloadResult {
    public boolean wasSuccessful();

    @Contract(value="-> this")
    @NotNull
    default public Failure asFailure() {
        if (this instanceof Failure) {
            return (Failure)this;
        }
        throw new IllegalArgumentException("Dependency was downloaded successfully.");
    }

    @Contract(pure=true)
    @NotNull
    public static Success success() {
        return Success.INSTANCE;
    }

    @NotNull
    public static Failure failure(@NotNull Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable cannot be null!");
        return new Failure(throwable);
    }

    public static final class Failure
    implements DependencyDownloadResult {
        private final Throwable throwable;

        Failure(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public boolean wasSuccessful() {
            return false;
        }

        @NotNull
        public Throwable getError() {
            return this.throwable;
        }
    }

    public static final class Success
    implements DependencyDownloadResult {
        private static final Success INSTANCE = new Success();

        private Success() {
        }

        @Override
        public boolean wasSuccessful() {
            return true;
        }
    }
}

