/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper;

import java.io.File;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xshyo.us.theglow.libs.zapper.Dependency;
import xshyo.us.theglow.libs.zapper.DependencyDownloadException;
import xshyo.us.theglow.libs.zapper.DependencyDownloadResult;
import xshyo.us.theglow.libs.zapper.DependencyScope;
import xshyo.us.theglow.libs.zapper.classloader.URLClassLoaderWrapper;
import xshyo.us.theglow.libs.zapper.meta.MetaReader;
import xshyo.us.theglow.libs.zapper.relocation.Relocation;
import xshyo.us.theglow.libs.zapper.relocation.Relocator;
import xshyo.us.theglow.libs.zapper.repository.Repository;

public final class DependencyManager
implements DependencyScope {
    public static boolean FAILED_TO_DOWNLOAD = false;
    private static final Pattern COLON = Pattern.compile(":");
    private final File directory;
    private final URLClassLoaderWrapper classLoader;
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final Set<Repository> repositories = new LinkedHashSet<Repository>();
    private final List<Relocation> relocations = new ArrayList<Relocation>();
    private final MetaReader metaReader = MetaReader.create();

    public DependencyManager(@NotNull File file, @NotNull URLClassLoaderWrapper uRLClassLoaderWrapper) {
        this.directory = file;
        this.classLoader = uRLClassLoaderWrapper;
        this.repositories.add(Repository.mavenCentral());
    }

    public void load() {
        block14: {
            try {
                ArrayList<Path> arrayList = new ArrayList<Path>();
                for (Dependency object : this.dependencies) {
                    File file = new File(this.directory, String.format("%s.%s-%s.jar", object.getGroupId(), object.getArtifactId(), object.getVersion()));
                    File file2 = new File(this.directory, String.format("%s.%s-%s-relocated.jar", object.getGroupId(), object.getArtifactId(), object.getVersion()));
                    if (this.hasRelocations() && file2.exists()) {
                        arrayList.add(file2.toPath());
                        continue;
                    }
                    if (!file.exists()) {
                        boolean bl = false;
                        ArrayList<String> arrayList2 = null;
                        for (Repository repository : this.repositories) {
                            DependencyDownloadResult dependencyDownloadResult = object.download(file, repository);
                            if (dependencyDownloadResult.wasSuccessful()) {
                                bl = true;
                                break;
                            }
                            (arrayList2 == null ? new ArrayList<String>() : arrayList2).add(repository.toString());
                        }
                        if (arrayList2 != null && !bl) {
                            throw new DependencyDownloadException(object, "Could not find dependency in any of the following repositories: " + String.join((CharSequence)"\n", arrayList2));
                        }
                    }
                    if (this.hasRelocations() && !file2.exists()) {
                        Relocator.relocate(file, file2, this.relocations);
                        file.delete();
                    }
                    if (this.hasRelocations()) {
                        arrayList.add(file2.toPath());
                        continue;
                    }
                    arrayList.add(file.toPath());
                }
                for (Path path : arrayList) {
                    this.classLoader.addURL(path.toUri().toURL());
                }
            }
            catch (DependencyDownloadException dependencyDownloadException) {
                if (dependencyDownloadException.getCause() instanceof UnknownHostException) {
                    Bukkit.getLogger().info("[" + this.metaReader.pluginName() + "] It appears you do not have an internet connection. Please provide an internet connection for once at least.");
                    FAILED_TO_DOWNLOAD = true;
                    break block14;
                }
                throw dependencyDownloadException;
            }
        }
    }

    @Override
    public void dependency(@NotNull Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void dependency(@NotNull String string) {
        String[] stringArray = COLON.split(string);
        this.dependencies.add(new Dependency(stringArray[0], stringArray[1], stringArray[2], stringArray.length == 4 ? stringArray[3] : null));
    }

    public void dependency(@NotNull String string, @NotNull String string2, @NotNull String string3) {
        this.dependencies.add(new Dependency(string, string2, string3));
    }

    public void dependency(@NotNull String string, @NotNull String string2, @NotNull String string3, @Nullable String string4) {
        this.dependencies.add(new Dependency(string, string2, string3, string4));
    }

    public void relocate(@NotNull Relocation relocation) {
        this.relocations.add(relocation);
    }

    public void repository(@NotNull Repository repository) {
        this.repositories.add(repository);
    }

    public boolean hasRelocations() {
        return !this.relocations.isEmpty();
    }
}

