/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.zapper.Dependency;
import xshyo.us.theglow.libs.zapper.relocation.Relocation;
import xshyo.us.theglow.libs.zapper.repository.Repository;
import xshyo.us.theglow.libs.zapper.util.ClassLoaderReader;

public final class RuntimeLibPluginConfiguration {
    @NotNull
    private final String libsFolder;
    @NotNull
    private final String relocationPrefix;
    @NotNull
    private final List<Dependency> dependencies;
    @NotNull
    private final List<Repository> repositories;
    @NotNull
    private final List<Relocation> relocations;

    RuntimeLibPluginConfiguration(@NotNull String string, @NotNull String string2, @NotNull List<Dependency> list, @NotNull List<Repository> list2, @NotNull List<Relocation> list3) {
        this.libsFolder = string;
        this.relocationPrefix = string2;
        this.dependencies = list;
        this.repositories = list2;
        this.relocations = list3;
    }

    @NotNull
    public static RuntimeLibPluginConfiguration parse() {
        try {
            Properties properties = RuntimeLibPluginConfiguration.parseProperties();
            String string = properties.getProperty("libs-folder");
            String string2 = properties.getProperty("relocation-prefix");
            List<Repository> list = RuntimeLibPluginConfiguration.parseRepositories();
            List<Dependency> list2 = RuntimeLibPluginConfiguration.parseDependencies();
            List<Relocation> list3 = RuntimeLibPluginConfiguration.parseRelocations();
            return new RuntimeLibPluginConfiguration(string, string2, list2, list, list3);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Generated Zapper files are missing. Have you applied the Gradle plugin?");
        }
    }

    @NotNull
    private static List<Relocation> parseRelocations() throws IOException {
        InputStream inputStream = ClassLoaderReader.getResource("zapper/relocations.txt");
        if (inputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<Relocation> arrayList = new ArrayList<Relocation>();
        for (String string : RuntimeLibPluginConfiguration.readAllLines(inputStream)) {
            String[] stringArray = string.split(":");
            arrayList.add(new Relocation(stringArray[0], stringArray[1]));
        }
        return arrayList;
    }

    @NotNull
    private static List<Dependency> parseDependencies() {
        InputStream inputStream = ClassLoaderReader.getResource("zapper/dependencies.txt");
        if (inputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        for (String string : RuntimeLibPluginConfiguration.readAllLines(inputStream)) {
            String[] stringArray = string.split(":");
            arrayList.add(new Dependency(stringArray[0], stringArray[1], stringArray[2], stringArray.length == 4 ? stringArray[3] : null));
        }
        return arrayList;
    }

    @NotNull
    private static List<Repository> parseRepositories() {
        InputStream inputStream = ClassLoaderReader.getResource("zapper/repositories.txt");
        if (inputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<Repository> arrayList = new ArrayList<Repository>();
        for (String string : RuntimeLibPluginConfiguration.readAllLines(inputStream)) {
            arrayList.add(Repository.maven(string));
        }
        return arrayList;
    }

    @NotNull
    private static Properties parseProperties() {
        Properties properties = new Properties();
        try (InputStream inputStream = ClassLoaderReader.getResource("zapper/zapper.properties");){
            properties.load(inputStream);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static List<String> readAllLines(@NotNull InputStream inputStream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            List<String> list = bufferedReader.lines().collect(Collectors.toList());
            return list;
        }
    }

    @NotNull
    public String getLibsFolder() {
        return this.libsFolder;
    }

    @NotNull
    public String getRelocationPrefix() {
        return this.relocationPrefix;
    }

    @NotNull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public List<Repository> getRepositories() {
        return this.repositories;
    }

    @NotNull
    public List<Relocation> getRelocations() {
        return this.relocations;
    }

    public String toString() {
        return "RuntimeLibPluginConfiguration(libsFolder=" + this.getLibsFolder() + ", relocationPrefix=" + this.getRelocationPrefix() + ", dependencies=" + this.getDependencies() + ", repositories=" + this.getRepositories() + ", relocations=" + this.getRelocations() + ")";
    }
}

