/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper.relocation;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.zapper.Dependency;
import xshyo.us.theglow.libs.zapper.classloader.IsolatedClassLoader;
import xshyo.us.theglow.libs.zapper.relocation.Relocation;
import xshyo.us.theglow.libs.zapper.repository.Repository;

public final class Relocator {
    private static boolean initialized = false;
    private static final List<Dependency> dependencies = Arrays.asList(new Dependency("org.ow2.asm", "asm", "9.7.1"), new Dependency("org.ow2.asm", "asm-commons", "9.7.1"), new Dependency("me.lucko", "jar-relocator", "1.7"));
    private static Constructor<?> relocatorConstructor;
    private static Method relocateMethod;

    private Relocator() {
    }

    public static void relocate(@NotNull File file, @NotNull File file2, @NotNull List<Relocation> list) {
        if (!initialized) {
            Relocator.downloadJarRelocator(file.getParentFile());
            initialized = true;
        }
        try {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (Relocation relocation : list) {
                linkedHashMap.put(relocation.getPattern(), relocation.getNewPattern());
            }
            Iterator<Relocation> iterator = relocatorConstructor.newInstance(file, file2, linkedHashMap);
            relocateMethod.invoke(iterator, new Object[0]);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static void downloadJarRelocator(File file) {
        try {
            Object object;
            URL[] uRLArray = new URL[3];
            file.mkdirs();
            for (int i = 0; i < dependencies.size(); ++i) {
                object = dependencies.get(i);
                File file2 = new File(file, String.format("%s.%s-%s.jar", ((Dependency)object).getGroupId(), ((Dependency)object).getArtifactId(), ((Dependency)object).getVersion()));
                if (!file2.exists()) {
                    ((Dependency)object).download(file2, Repository.mavenCentral());
                }
                uRLArray[i] = file2.toURI().toURL();
            }
            IsolatedClassLoader isolatedClassLoader = new IsolatedClassLoader(uRLArray);
            object = isolatedClassLoader.loadClass("me.lucko.jarrelocator.JarRelocator");
            relocatorConstructor = ((Class)object).getDeclaredConstructor(File.class, File.class, Map.class);
            relocatorConstructor.setAccessible(true);
            relocateMethod = ((Class)object).getDeclaredMethod("run", new Class[0]);
            relocateMethod.setAccessible(true);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

