/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper.repository;

import java.net.URL;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.zapper.Dependency;
import xshyo.us.theglow.libs.zapper.repository.Repository;

final class MavenRepository
implements Repository {
    private static final MavenRepository MAVEN_CENTRAL = new MavenRepository("https://repo1.maven.org/maven2/");
    private static final MavenRepository JITPACK = new MavenRepository("https://jitpack.io/");
    private static final MavenRepository MINECRAFT = new MavenRepository("https://libraries.minecraft.net/");
    private static final MavenRepository PAPER = new MavenRepository("https://papermc.io/repo/repository/maven-public/");
    private final String repoURL;

    @NotNull
    public static MavenRepository mavenCentral() {
        return MAVEN_CENTRAL;
    }

    @NotNull
    public static MavenRepository jitpack() {
        return JITPACK;
    }

    @NotNull
    public static MavenRepository minecraft() {
        return MINECRAFT;
    }

    @NotNull
    public static MavenRepository paper() {
        return PAPER;
    }

    @NotNull
    public static MavenRepository maven(@NotNull String string) {
        return new MavenRepository(string);
    }

    private MavenRepository(@NotNull String string) {
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        this.repoURL = string;
    }

    public String getRepositoryURL() {
        return this.repoURL;
    }

    public String toString() {
        return this.getRepositoryURL();
    }

    @Override
    @NotNull
    public URL resolve(@NotNull Dependency dependency) throws Exception {
        return new URL(this.repoURL + dependency.getMavenPath() + ".jar");
    }

    @Override
    @NotNull
    public URL resolvePom(@NotNull Dependency dependency) throws Exception {
        return new URL(this.repoURL + dependency.getMavenPath() + ".pom");
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MavenRepository mavenRepository = (MavenRepository)object;
        return Objects.equals(this.repoURL, mavenRepository.repoURL);
    }

    public int hashCode() {
        return Objects.hashCode(this.repoURL);
    }
}

