/*
 * Decompiled with CFR 0.152.
 */
package xshyo.us.theglow.libs.zapper.repository;

import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import xshyo.us.theglow.libs.zapper.Dependency;
import xshyo.us.theglow.libs.zapper.repository.MavenRepository;

public interface Repository {
    @NotNull
    public URL resolve(@NotNull Dependency var1) throws Exception;

    @NotNull
    public URL resolvePom(@NotNull Dependency var1) throws Exception;

    @NotNull
    public static Repository maven(@NotNull URL uRL) {
        return MavenRepository.maven(uRL.toString());
    }

    @NotNull
    public static Repository maven(@NotNull String string) {
        return MavenRepository.maven(string);
    }

    @NotNull
    public static Repository mavenLocal() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".m2" + File.separator + "repository");
        return Repository.maven(file);
    }

    @NotNull
    public static Repository maven(@NotNull File file) {
        return Repository.maven(file.toURI().toURL().toString());
    }

    @NotNull
    public static Repository mavenCentral() {
        return MavenRepository.mavenCentral();
    }

    @NotNull
    public static Repository jitpack() {
        return MavenRepository.jitpack();
    }

    @NotNull
    public static Repository paper() {
        return MavenRepository.paper();
    }

    @NotNull
    public static Repository minecraft() {
        return MavenRepository.minecraft();
    }
}

