/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.listener;

import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.events.LegendControlDefenderEvent;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol_defender.util.WebhookUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DefenderListener {
    private final Map<UUID, UUID> LEGENDARY_DEFENDER = new HashMap<UUID, UUID>();

    public boolean hasLegendaryDefender(@Nonnull UUID pokemonUUID) {
        return this.LEGENDARY_DEFENDER.containsKey(pokemonUUID);
    }

    public boolean addLegendaryDefender(@Nonnull UUID pokemonUUID, @Nonnull UUID playerUUID) {
        if (this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.put(pokemonUUID, playerUUID);
        return true;
    }

    public boolean removeLegendaryDefender(@Nonnull UUID pokemonUUID) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.remove(pokemonUUID);
        return true;
    }

    public boolean hasLegendaryPlayerOwner(@Nonnull UUID pokemonUUID, @Nonnull ServerPlayerEntity player) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        UUID ownerUUID = this.LEGENDARY_DEFENDER.get(pokemonUUID);
        if (ownerUUID.equals(player.func_110124_au())) {
            return false;
        }
        return !LegendControlFactory.PlayerProvider.hasPlayerTrust(ownerUUID, player.func_110124_au());
    }

    @SubscribeEvent
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        PixelmonEntity pixelmonEntity = (PixelmonEntity)event.action.getOrCreateEntity();
        this.addLegendaryDefender(pixelmonEntity.func_110124_au(), event.action.spawnLocation.cause.func_110124_au());
        if (LegendControlDefender.getInstance().getConfig().getProtectedTime() > 0) {
            this.startDefender(pixelmonEntity);
        }
    }

    private void startDefender(@Nonnull PixelmonEntity pixelmonEntity) {
        TaskTimer.builder().delay((long)LegendControlDefender.getInstance().getConfig().getProtectedTime() * 20L).consume(task -> {
            if (this.hasLegendaryDefender(pixelmonEntity.func_110124_au()) && pixelmonEntity.func_70089_S() && !pixelmonEntity.hasOwner()) {
                UtilChat.broadcast((String)LegendControlDefender.getInstance().getLocale().getProtection().replace("%pokemon%", pixelmonEntity.getPokemonName()));
                MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.ExpiredDefender(pixelmonEntity));
                this.removeLegendaryDefender(pixelmonEntity.func_110124_au());
                WebhookUtils.defenderExpiredWebhook(pixelmonEntity);
            }
        }).build();
    }

    @SubscribeEvent
    public void onKey(KeyEvent event) {
        if (event.key != EnumKeyPacketMode.ActionKeyEntity) {
            return;
        }
        ServerPlayerEntity player = event.player;
        for (Pokemon pokemon : StorageProxy.getStorageManager().getParty(player).getTeam()) {
            pokemon.ifEntityExists(pixelmonEntity -> {
                LivingEntity target = pixelmonEntity.func_70638_az();
                if (target instanceof PixelmonEntity && this.hasLegendaryPlayerOwner(target.func_110124_au(), player) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((PixelmonEntity)pixelmonEntity, player))) {
                    player.getEntity().func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()), Util.field_240973_b_);
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onBattleStarted(BattleStartedEvent event) {
        if (event.getBattleController().isPvP()) {
            return;
        }
        List participants = event.getBattleController().participants;
        PlayerParticipant player = participants.stream().filter(PlayerParticipant.class::isInstance).map(PlayerParticipant.class::cast).findFirst().orElse(null);
        WildPixelmonParticipant wildPixelmon = participants.stream().filter(WildPixelmonParticipant.class::isInstance).map(WildPixelmonParticipant.class::cast).findFirst().orElse(null);
        if (participants.size() == 2 && player != null && wildPixelmon != null && this.hasLegendaryPlayerOwner(wildPixelmon.getEntity().func_110124_au(), (ServerPlayerEntity)player.getEntity()) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((PixelmonEntity)wildPixelmon.getEntity(), (ServerPlayerEntity)player.getEntity()))) {
            player.getEntity().func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onStartCapture(CaptureEvent.StartCapture event) {
        ServerPlayerEntity player = event.getPlayer();
        if (this.hasLegendaryPlayerOwner(event.getPokemon().func_110124_au(), player) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender(event.getPokemon(), player))) {
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70441_a(event.getPokeBall().getBallType().getBallItem());
            }
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()), Util.field_240973_b_);
            event.setCanceled(true);
        }
    }
}

