/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol_defender.config.LocaleConfig;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;

public class LegendaryTrustCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ltrust").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.ltrust"))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String playerName : ((CommandSource)s.getSource()).func_197011_j()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        }).executes(e -> LegendaryTrustCommand.executeAdd(((CommandSource)e.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (UUID playerUUID : LegendControlFactory.PlayerProvider.getPlayersTrust(((CommandSource)s.getSource()).func_197035_h().func_110124_au())) {
                String name = UtilPlayer.getPlayerName((UUID)playerUUID);
                if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }).executes(e -> LegendaryTrustCommand.executeRemove(((CommandSource)e.getSource()).func_197035_h(), StringArgumentType.getString((CommandContext)e, (String)"player"))))).then(Commands.func_197057_a((String)"all").executes(e -> LegendaryTrustCommand.executeRemoveAll(((CommandSource)e.getSource()).func_197035_h()))))).then(Commands.func_197057_a((String)"list").executes(e -> LegendaryTrustCommand.executeList(((CommandSource)e.getSource()).func_197035_h())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").requires(p -> UtilPermission.hasPermission((CommandSource)p, (String)"minecraft.command.ltrust.reload"))).executes(e -> LegendaryTrustCommand.executeReload((CommandSource)e.getSource()))));
    }

    private static int executeAdd(ServerPlayerEntity player, String target) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (!UtilPlayer.hasUUID((String)target)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        if (player.func_110124_au().equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getCantSelfTrust()), Util.field_240973_b_);
            return 0;
        }
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        if (trustedPlayers.contains(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getAlreadyTrusted()), Util.field_240973_b_);
            return 0;
        }
        if (LegendControlDefender.getInstance().getConfig().getTrustLimit() > 0 && trustedPlayers.size() >= LegendControlDefender.getInstance().getConfig().getTrustLimit()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTrustLimit()), Util.field_240973_b_);
            return 0;
        }
        LegendControlFactory.PlayerProvider.addPlayerTrust(player.func_110124_au(), targetUUID);
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getAddTrust().replace("%player%", target)), Util.field_240973_b_);
        return 1;
    }

    private static int executeRemove(ServerPlayerEntity player, String target) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (!UtilPlayer.hasUUID((String)target)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)), Util.field_240973_b_);
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        if (trustedPlayers.isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()), Util.field_240973_b_);
            return 0;
        }
        if (!trustedPlayers.contains(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getNotPlayerTrust()), Util.field_240973_b_);
            return 0;
        }
        LegendControlFactory.PlayerProvider.removePlayerTrust(player.func_110124_au(), targetUUID);
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getRemoveTrust().replace("%player%", target)), Util.field_240973_b_);
        return 1;
    }

    private static int executeRemoveAll(ServerPlayerEntity player) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au()).isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()), Util.field_240973_b_);
            return 0;
        }
        LegendControlFactory.PlayerProvider.removePlayersTrust(player.func_110124_au());
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getRemoveAllTrust()), Util.field_240973_b_);
        return 1;
    }

    private static int executeList(ServerPlayerEntity player) {
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (trustedPlayers.isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getListTrust()), Util.field_240973_b_);
        for (UUID playerUUID : trustedPlayers) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTrustedPlayers().replace("%player%", UtilPlayer.getPlayerName((UUID)playerUUID))), Util.field_240973_b_);
        }
        return 1;
    }

    private static int executeReload(CommandSource source) {
        LegendControlDefender.getInstance().loadConfig();
        LegendControlDefender.getInstance().loadStorage();
        source.func_197030_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getReload()), false);
        return 1;
    }
}

