/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.storage.player.impl;

import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.storage.player.PlayerProvider;
import com.vecoo.legendcontrol_defender.storage.player.PlayerStorage;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;

public class PlayerJsonProvider
implements PlayerProvider {
    private final transient String filePath;
    private final Map<UUID, PlayerStorage> map;

    public PlayerJsonProvider(String filePath, MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.map = new ConcurrentHashMap<UUID, PlayerStorage>();
    }

    @Override
    public Map<UUID, PlayerStorage> getMap() {
        return this.map;
    }

    @Override
    public PlayerStorage getPlayerStorage(UUID playerUUID) {
        if (this.map.get(playerUUID) == null) {
            new PlayerStorage(playerUUID, new HashSet<UUID>());
        }
        return this.map.get(playerUUID);
    }

    @Override
    public void updatePlayerStorage(PlayerStorage storage) {
        this.map.put(storage.getUUID(), storage);
        this.write(storage).thenAccept(success -> {
            if (!success.booleanValue()) {
                LegendControlDefender.getLogger().error("[LegendControl-Defender] Failed to write PlayerStorage.");
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> write(PlayerStorage storage) {
        return UtilGson.writeFileAsync((String)this.filePath, (String)(storage.getUUID() + ".json"), (String)UtilGson.newGson().toJson((Object)storage));
    }

    @Override
    public void init() {
        String[] list = UtilGson.checkForDirectory((String)this.filePath).list();
        if (list == null) {
            return;
        }
        for (String file : list) {
            UtilGson.readFileAsync((String)this.filePath, (String)file, el -> {
                PlayerStorage storage = (PlayerStorage)UtilGson.newGson().fromJson(el, PlayerStorage.class);
                this.map.put(storage.getUUID(), storage);
            });
        }
    }
}

