/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.listener;

import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.events.LegendControlDefenderEvent;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol_defender.util.WebhookUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;

public class DefenderListener {
    private final Map<UUID, UUID> LEGENDARY_DEFENDER = new HashMap<UUID, UUID>();

    public boolean hasLegendaryDefender(UUID pokemonUUID) {
        return this.LEGENDARY_DEFENDER.containsKey(pokemonUUID);
    }

    public boolean addLegendaryDefender(UUID pokemonUUID, UUID playerUUID) {
        if (this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.put(pokemonUUID, playerUUID);
        return true;
    }

    public boolean removeLegendaryDefender(UUID pokemonUUID) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.remove(pokemonUUID);
        return true;
    }

    public boolean hasLegendaryPlayerOwner(UUID pokemonUUID, ServerPlayer player) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        UUID ownerUUID = this.LEGENDARY_DEFENDER.get(pokemonUUID);
        if (ownerUUID.equals(player.getUUID())) {
            return false;
        }
        return !LegendControlFactory.PlayerProvider.hasPlayerTrust(ownerUUID, player.getUUID());
    }

    @SubscribeEvent
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        PixelmonEntity pixelmonEntity = (PixelmonEntity)event.action.getOrCreateEntity();
        this.addLegendaryDefender(pixelmonEntity.getUUID(), event.action.spawnLocation.cause.getUUID());
        if (LegendControlDefender.getInstance().getConfig().getProtectedTime() > 0) {
            this.startDefender(pixelmonEntity);
        }
    }

    private void startDefender(PixelmonEntity pixelmonEntity) {
        TaskTimer.builder().delay((long)LegendControlDefender.getInstance().getConfig().getProtectedTime() * 20L).consume(task -> {
            if (this.hasLegendaryDefender(pixelmonEntity.getUUID()) && pixelmonEntity.isAlive() && !pixelmonEntity.hasOwner()) {
                UtilChat.broadcast((String)LegendControlDefender.getInstance().getLocale().getProtection().replace("%pokemon%", pixelmonEntity.getPokemonName()));
                NeoForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.ExpiredDefender(pixelmonEntity));
                this.removeLegendaryDefender(pixelmonEntity.getUUID());
                WebhookUtils.defenderExpiredWebhook(pixelmonEntity);
            }
        }).build();
    }

    @SubscribeEvent
    public void onKey(KeyEvent event) {
        if (event.key != EnumKeyPacketMode.ActionKeyEntity) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getStorageManager().getPartyNow((Player)event.player);
        if (party == null) {
            return;
        }
        ServerPlayer player = event.player;
        for (Pokemon pokemon : party.getTeam()) {
            pokemon.ifEntityExists(pixelmonEntity -> {
                LivingEntity target = pixelmonEntity.getTarget();
                if (target instanceof PixelmonEntity && this.hasLegendaryPlayerOwner(target.getUUID(), player) && !((LegendControlDefenderEvent.WorkedDefender)NeoForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((PixelmonEntity)pixelmonEntity, player))).isCanceled()) {
                    player.sendSystemMessage(UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onBattleStarted(BattleStartedEvent.Pre event) {
        if (event.getBattleController().isPvP()) {
            return;
        }
        List participants = event.getBattleController().participants;
        PlayerParticipant player = participants.stream().filter(PlayerParticipant.class::isInstance).map(PlayerParticipant.class::cast).findFirst().orElse(null);
        WildPixelmonParticipant wildPixelmon = participants.stream().filter(WildPixelmonParticipant.class::isInstance).map(WildPixelmonParticipant.class::cast).findFirst().orElse(null);
        if (participants.size() == 2 && player != null && wildPixelmon != null && player.getPlayer() != null && wildPixelmon.getEntity() != null && this.hasLegendaryPlayerOwner(wildPixelmon.getEntity().getUUID(), player.getPlayer()) && !((LegendControlDefenderEvent.WorkedDefender)NeoForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((PixelmonEntity)wildPixelmon.getEntity(), player.getPlayer()))).isCanceled()) {
            player.getPlayer().sendSystemMessage(UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onStartCapture(CaptureEvent.StartCapture event) {
        ServerPlayer player = event.getPlayer();
        if (this.hasLegendaryPlayerOwner(event.getPokemon().getUUID(), player) && !((LegendControlDefenderEvent.WorkedDefender)NeoForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender(event.getPokemon().getPixelmonEntity().orElse(null), player))).isCanceled()) {
            if (!player.isCreative()) {
                player.getInventory().add(event.getPokeBall().getBallItem());
            }
            player.sendSystemMessage(UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
            event.setCanceled(true);
        }
    }
}

