/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.permission.UtilPermission;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol_defender.config.LocaleConfig;
import com.vecoo.legendcontrol_defender.util.PermissionNodes;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class LegendaryTrustCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ltrust").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEGENDARYTRUST_COMMAND))).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (String playerName : ((CommandSourceStack)s.getSource()).getOnlinePlayerNames()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        }).executes(e -> LegendaryTrustCommand.executeAdd(((CommandSourceStack)e.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)e, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((s, builder) -> {
            for (UUID playerUUID : LegendControlFactory.PlayerProvider.getPlayersTrust(((CommandSourceStack)s.getSource()).getPlayerOrException().getUUID())) {
                String name = UtilPlayer.getPlayerName((UUID)playerUUID);
                if (!name.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(name);
            }
            return builder.buildFuture();
        }).executes(e -> LegendaryTrustCommand.executeRemove(((CommandSourceStack)e.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)e, (String)"player"))))).then(Commands.literal((String)"all").executes(e -> LegendaryTrustCommand.executeRemoveAll(((CommandSourceStack)e.getSource()).getPlayerOrException()))))).then(Commands.literal((String)"list").executes(e -> LegendaryTrustCommand.executeList(((CommandSourceStack)e.getSource()).getPlayerOrException())))).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(p -> UtilPermission.hasPermission((CommandSourceStack)p, PermissionNodes.LEGENDARYTRUST_RELOAD_COMMAND))).executes(e -> LegendaryTrustCommand.executeReload((CommandSourceStack)e.getSource()))));
    }

    private static int executeAdd(ServerPlayer player, String target) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (!UtilPlayer.hasUUID((String)target)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        if (player.getUUID().equals(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getCantSelfTrust()));
            return 0;
        }
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.getUUID());
        if (trustedPlayers.contains(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getAlreadyTrusted()));
            return 0;
        }
        if (LegendControlDefender.getInstance().getConfig().getTrustLimit() > 0 && trustedPlayers.size() >= LegendControlDefender.getInstance().getConfig().getTrustLimit()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getTrustLimit()));
            return 0;
        }
        LegendControlFactory.PlayerProvider.addPlayerTrust(player.getUUID(), targetUUID);
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getAddTrust().replace("%player%", target)));
        return 1;
    }

    private static int executeRemove(ServerPlayer player, String target) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (!UtilPlayer.hasUUID((String)target)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)));
            return 0;
        }
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.getUUID());
        if (trustedPlayers.isEmpty()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return 0;
        }
        if (!trustedPlayers.contains(targetUUID)) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getNotPlayerTrust()));
            return 0;
        }
        LegendControlFactory.PlayerProvider.removePlayerTrust(player.getUUID(), targetUUID);
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getRemoveTrust().replace("%player%", target)));
        return 1;
    }

    private static int executeRemoveAll(ServerPlayer player) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (LegendControlFactory.PlayerProvider.getPlayersTrust(player.getUUID()).isEmpty()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return 0;
        }
        LegendControlFactory.PlayerProvider.removePlayersTrust(player.getUUID());
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getRemoveAllTrust()));
        return 1;
    }

    private static int executeList(ServerPlayer player) {
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.getUUID());
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (trustedPlayers.isEmpty()) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return 0;
        }
        player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getListTrust()));
        for (UUID playerUUID : trustedPlayers) {
            player.sendSystemMessage(UtilChat.formatMessage((String)localeConfig.getTrustedPlayers().replace("%player%", UtilPlayer.getPlayerName((UUID)playerUUID))));
        }
        return 1;
    }

    private static int executeReload(CommandSourceStack source) {
        LegendControlDefender.getInstance().loadConfig();
        source.sendSystemMessage(UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getReload()));
        return 1;
    }
}

