/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.storage;

import com.google.gson.Gson;
import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.storage.PlayerStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public class PlayerProvider {
    private final transient String filePath;
    private final Map<UUID, PlayerStorage> map;

    public PlayerProvider(String filePath, MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.map = new HashMap<UUID, PlayerStorage>();
    }

    public Map<UUID, PlayerStorage> getMap() {
        return this.map;
    }

    public PlayerStorage getPlayerStorage(UUID playerUUID) {
        if (this.map.get(playerUUID) == null) {
            new PlayerStorage(playerUUID, new HashSet<UUID>());
        }
        return this.map.get(playerUUID);
    }

    public void updatePlayerStorage(PlayerStorage storage) {
        storage.setDirty(true);
        this.map.put(storage.getPlayerUUID(), storage);
    }

    public void write() {
        Gson gson = UtilGson.newGson();
        for (PlayerStorage storage : this.map.values()) {
            UtilGson.writeFileAsync((String)this.filePath, (String)(String.valueOf(storage.getPlayerUUID()) + ".json"), (String)gson.toJson((Object)this.getPlayerStorage(storage.getPlayerUUID()))).join();
        }
    }

    private void writeInterval() {
        TaskTimer.builder().withoutDelay().interval(3600L).infinite().consume(task -> {
            if (LegendControlDefender.getInstance().getServer().isRunning()) {
                Gson gson = UtilGson.newGson();
                for (PlayerStorage storage : this.map.values()) {
                    if (!storage.isDirty()) continue;
                    UtilGson.writeFileAsync((String)this.filePath, (String)(String.valueOf(storage.getPlayerUUID()) + ".json"), (String)gson.toJson((Object)storage)).thenRun(() -> storage.setDirty(false));
                }
            }
        }).build();
    }

    public void init() {
        String[] list = UtilGson.checkForDirectory((String)this.filePath).list();
        if (list == null) {
            return;
        }
        for (String file : list) {
            UtilGson.readFileAsync((String)this.filePath, (String)file, el -> {
                PlayerStorage storage = (PlayerStorage)UtilGson.newGson().fromJson(el, PlayerStorage.class);
                storage.setDirty(false);
                this.map.put(storage.getPlayerUUID(), storage);
            }).join();
        }
        this.writeInterval();
    }
}

