/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.storage;

import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.events.PlayerTrustEvent;
import java.util.Set;
import java.util.UUID;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PlayerStorage {
    private final UUID playerUUID;
    private final Set<UUID> playersTrust;
    private transient boolean isDirty;

    public PlayerStorage(UUID playerUUID, Set<UUID> playersTrust) {
        this.playerUUID = playerUUID;
        this.playersTrust = playersTrust;
        LegendControlDefender.getInstance().getPlayerProvider().updatePlayerStorage(this);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Set<UUID> getPlayersTrust() {
        return this.playersTrust;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addPlayerTrust(UUID playerUUID) {
        if (!((PlayerTrustEvent.Clear)NeoForge.EVENT_BUS.post((Event)new PlayerTrustEvent.Clear(this.playerUUID))).isCanceled()) {
            this.playersTrust.add(playerUUID);
            LegendControlDefender.getInstance().getPlayerProvider().updatePlayerStorage(this);
        }
    }

    public void removePlayerTrust(UUID playerUUID) {
        if (!((PlayerTrustEvent.Clear)NeoForge.EVENT_BUS.post((Event)new PlayerTrustEvent.Clear(this.playerUUID))).isCanceled()) {
            this.playersTrust.remove(playerUUID);
            LegendControlDefender.getInstance().getPlayerProvider().updatePlayerStorage(this);
        }
    }

    public void clearPlayersTrust() {
        if (!((PlayerTrustEvent.Clear)NeoForge.EVENT_BUS.post((Event)new PlayerTrustEvent.Clear(this.playerUUID))).isCanceled()) {
            this.playersTrust.clear();
            LegendControlDefender.getInstance().getPlayerProvider().updatePlayerStorage(this);
        }
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }
}

