/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.api.yaml.YamlConfigFactory;
import com.vecoo.legendcontrol_defender.command.LegendaryTrustCommand;
import com.vecoo.legendcontrol_defender.config.DiscordConfig;
import com.vecoo.legendcontrol_defender.config.LocaleConfig;
import com.vecoo.legendcontrol_defender.config.ServerConfig;
import com.vecoo.legendcontrol_defender.discord.DiscordWebhook;
import com.vecoo.legendcontrol_defender.listener.DefenderListener;
import com.vecoo.legendcontrol_defender.storage.PlayerProvider;
import com.vecoo.legendcontrol_defender.util.PermissionNodes;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import org.slf4j.Logger;

@Mod(value="legendcontrol_defender")
public class LegendControlDefender {
    public static final String MOD_ID = "legendcontrol_defender";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static LegendControlDefender instance;
    private ServerConfig config;
    private LocaleConfig locale;
    private DiscordConfig discord;
    private PlayerProvider playerProvider;
    private MinecraftServer server;
    private DiscordWebhook webhook;

    public LegendControlDefender() {
        instance = this;
        this.loadConfig();
        NeoForge.EVENT_BUS.register((Object)this);
        Pixelmon.EVENT_BUS.register((Object)new DefenderListener());
    }

    @SubscribeEvent
    public void onPermissionGather(PermissionGatherEvent.Nodes event) {
        PermissionNodes.registerPermission(event);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        LegendaryTrustCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.server = event.getServer();
        this.loadStorage();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.playerProvider.write();
    }

    public void loadConfig() {
        try {
            this.config = (ServerConfig)YamlConfigFactory.getInstance(ServerConfig.class);
            this.locale = (LocaleConfig)YamlConfigFactory.getInstance(LocaleConfig.class);
            this.discord = (DiscordConfig)YamlConfigFactory.getInstance(DiscordConfig.class);
            this.webhook = new DiscordWebhook(this.discord.getWebhookUrl());
        }
        catch (Exception e) {
            LOGGER.error("Error load config.", (Throwable)e);
        }
    }

    public void loadStorage() {
        try {
            if (this.playerProvider == null) {
                this.playerProvider = new PlayerProvider("/%directory%/storage/LegendControl/Defender/players/", this.server);
            }
            this.playerProvider.init();
        }
        catch (Exception e) {
            LOGGER.error("Error load storage.", (Throwable)e);
        }
    }

    public static LegendControlDefender getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public ServerConfig getConfig() {
        return LegendControlDefender.instance.config;
    }

    public LocaleConfig getLocale() {
        return LegendControlDefender.instance.locale;
    }

    public DiscordConfig getDiscordConfig() {
        return LegendControlDefender.instance.discord;
    }

    public PlayerProvider getPlayerProvider() {
        return LegendControlDefender.instance.playerProvider;
    }

    public MinecraftServer getServer() {
        return LegendControlDefender.instance.server;
    }

    public DiscordWebhook getWebhook() {
        return LegendControlDefender.instance.webhook;
    }
}

