/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.storage;

import com.google.gson.Gson;
import com.vecoo.extralib.gson.UtilGson;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.extralib.world.UtilWorld;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.storage.PlayerStorage;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class PlayerProvider {
    private final transient String filePath;
    private final Map<UUID, PlayerStorage> map;
    private transient boolean intervalStarted = false;

    public PlayerProvider(@NotNull String filePath, @NotNull MinecraftServer server) {
        this.filePath = UtilWorld.worldDirectory((String)filePath, (MinecraftServer)server);
        this.map = new HashMap<UUID, PlayerStorage>();
    }

    @NotNull
    public Map<UUID, PlayerStorage> getStorage() {
        return this.map;
    }

    @NotNull
    public PlayerStorage getStorage(@NotNull UUID playerUUID) {
        if (this.map.get(playerUUID) == null) {
            new PlayerStorage(playerUUID, new LinkedHashSet<UUID>());
        }
        return this.map.get(playerUUID);
    }

    public void updatePlayerStorage(@NotNull PlayerStorage storage) {
        storage.setDirty(true);
        this.map.put(storage.getPlayerUUID(), storage);
    }

    public void write() {
        Gson gson = UtilGson.newGson();
        for (PlayerStorage storage : this.map.values()) {
            UtilGson.writeFileAsync((String)this.filePath, (String)(String.valueOf(storage.getPlayerUUID()) + ".json"), (String)gson.toJson((Object)storage)).join();
        }
    }

    private void writeInterval() {
        if (!this.intervalStarted) {
            TaskTimer.builder().withoutDelay().interval(6000L).infinite().consume(task -> {
                if (LegendControlDefender.getInstance().getServer().isRunning()) {
                    Gson gson = UtilGson.newGson();
                    for (PlayerStorage storage : this.map.values()) {
                        if (!storage.isDirty()) continue;
                        UtilGson.writeFileAsync((String)this.filePath, (String)(String.valueOf(storage.getPlayerUUID()) + ".json"), (String)gson.toJson((Object)storage)).thenRun(() -> storage.setDirty(false));
                    }
                }
            }).build();
            this.intervalStarted = true;
        }
    }

    public void init() {
        String[] list = UtilGson.checkForDirectory((String)this.filePath).list();
        if (list == null) {
            return;
        }
        for (String file : list) {
            UtilGson.readFileAsync((String)this.filePath, (String)file, el -> {
                PlayerStorage storage = (PlayerStorage)UtilGson.newGson().fromJson(el, PlayerStorage.class);
                storage.setDirty(false);
                this.map.put(storage.getPlayerUUID(), storage);
            }).join();
        }
        this.writeInterval();
    }
}

