/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.command;

import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.player.UtilPlayer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import com.vecoo.legendcontrol_defender.config.LocaleConfig;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;

public class LegendaryTrustCommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "ltrust";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "/ltrust";
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender) {
        return true;
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args, BlockPos targetPos) {
        if (args.length == 1) {
            return LegendaryTrustCommand.func_71530_a((String[])args, (String[])new String[]{"add", "remove", "list"});
        }
        if (args.length == 2 && !args[0].equals("list") && !args[0].equals("reload")) {
            return LegendaryTrustCommand.func_71530_a((String[])args, (String[])LegendControlDefender.getInstance().getServer().func_184103_al().func_72369_d());
        }
        return Collections.emptyList();
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
        try {
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            switch (args[0]) {
                case "add": {
                    LegendaryTrustCommand.executeAdd((EntityPlayerMP)sender, args[1]);
                    break;
                }
                case "remove": {
                    if (args[1].equals("all")) {
                        LegendaryTrustCommand.executeRemoveAll(player);
                        break;
                    }
                    LegendaryTrustCommand.executeRemove(player, args[1]);
                    break;
                }
                case "list": {
                    LegendaryTrustCommand.executeList(player);
                }
            }
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)UtilChat.formatMessage((String)"/ltrust"));
        }
    }

    private static void executeAdd(@Nonnull EntityPlayerMP player, @Nonnull String target) {
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)));
            return;
        }
        if (player.func_110124_au().equals(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getCantSelfTrust()));
            return;
        }
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        if (trustedPlayers.contains(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getAlreadyTrusted()));
            return;
        }
        if (LegendControlDefender.getInstance().getConfig().getTrustLimit() > 0 && trustedPlayers.size() >= LegendControlDefender.getInstance().getConfig().getTrustLimit()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTrustLimit()));
            return;
        }
        if (!LegendControlFactory.PlayerProvider.addPlayerTrust(player.func_110124_au(), targetUUID)) {
            return;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getAddTrust().replace("%player%", target)));
    }

    private static void executeRemove(@Nonnull EntityPlayerMP player, @Nonnull String target) {
        UUID targetUUID = UtilPlayer.getUUID((String)target);
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (targetUUID == null) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getPlayerNotFound().replace("%player%", target)));
            return;
        }
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        if (trustedPlayers.isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return;
        }
        if (!trustedPlayers.contains(targetUUID)) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getNotPlayerTrust()));
            return;
        }
        if (!LegendControlFactory.PlayerProvider.removePlayerTrust(player.func_110124_au(), targetUUID)) {
            return;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getRemoveTrust().replace("%player%", target)));
    }

    private static void executeRemoveAll(@Nonnull EntityPlayerMP player) {
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au()).isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return;
        }
        if (!LegendControlFactory.PlayerProvider.clearPlayersTrust(player.func_110124_au())) {
            return;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getRemoveAllTrust()));
    }

    private static void executeList(@Nonnull EntityPlayerMP player) {
        Set<UUID> trustedPlayers = LegendControlFactory.PlayerProvider.getPlayersTrust(player.func_110124_au());
        LocaleConfig localeConfig = LegendControlDefender.getInstance().getLocale();
        if (trustedPlayers.isEmpty()) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getEmptyTrust()));
            return;
        }
        player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getListTrust()));
        for (UUID playerUUID : trustedPlayers) {
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)localeConfig.getTrustedPlayers().replace("%player%", UtilPlayer.getPlayerName((UUID)playerUUID))));
        }
    }
}

