/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.legendcontrol_defender.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.events.KeyEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumKeyPacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.vecoo.extralib.chat.UtilChat;
import com.vecoo.extralib.task.TaskTimer;
import com.vecoo.legendcontrol_defender.LegendControlDefender;
import com.vecoo.legendcontrol_defender.api.events.LegendControlDefenderEvent;
import com.vecoo.legendcontrol_defender.api.factory.LegendControlFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class DefenderListener {
    private final Map<UUID, UUID> LEGENDARY_DEFENDER = new HashMap<UUID, UUID>();

    public boolean hasLegendaryDefender(UUID pokemonUUID) {
        return this.LEGENDARY_DEFENDER.containsKey(pokemonUUID);
    }

    public boolean addLegendaryDefender(UUID pokemonUUID, UUID playerUUID) {
        if (this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.put(pokemonUUID, playerUUID);
        return true;
    }

    public boolean removeLegendaryDefender(UUID pokemonUUID) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        this.LEGENDARY_DEFENDER.remove(pokemonUUID);
        return true;
    }

    public boolean hasLegendaryPlayerOwner(UUID pokemonUUID, EntityPlayerMP player) {
        if (!this.hasLegendaryDefender(pokemonUUID)) {
            return false;
        }
        UUID ownerUUID = this.LEGENDARY_DEFENDER.get(pokemonUUID);
        if (ownerUUID.equals(player.func_110124_au())) {
            return false;
        }
        return !LegendControlFactory.PlayerProvider.hasPlayerTrust(ownerUUID, player.func_110124_au());
    }

    @SubscribeEvent
    public void onDoSpawn(LegendarySpawnEvent.DoSpawn event) {
        EntityPixelmon entityPixelmon = (EntityPixelmon)event.action.getOrCreateEntity();
        this.addLegendaryDefender(entityPixelmon.func_110124_au(), event.action.spawnLocation.cause.func_110124_au());
        TaskTimer.builder().delay(1L).consume(task -> {
            if (entityPixelmon.func_70089_S() && LegendControlDefender.getInstance().getConfig().getProtectedTime() > 0) {
                this.startDefender(entityPixelmon);
            }
        }).build();
    }

    private void startDefender(EntityPixelmon entityPixelmon) {
        TaskTimer.builder().delay((long)LegendControlDefender.getInstance().getConfig().getProtectedTime() * 20L).consume(task -> {
            if (this.hasLegendaryDefender(entityPixelmon.func_110124_au()) && entityPixelmon.func_70089_S() && !entityPixelmon.hasOwner()) {
                UtilChat.broadcast((String)LegendControlDefender.getInstance().getLocale().getProtection().replace("%pokemon%", entityPixelmon.getPokemonName()));
                MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.ExpiredDefender(entityPixelmon));
                this.removeLegendaryDefender(entityPixelmon.func_110124_au());
            }
        }).build();
    }

    @SubscribeEvent
    public void onKey(KeyEvent event) {
        if (event.key != EnumKeyPacketMode.ActionKeyEntity) {
            return;
        }
        EntityPlayerMP player = event.player;
        for (Pokemon pokemon : Pixelmon.storageManager.getParty(player).getTeam()) {
            pokemon.ifEntityExists(pixelmonEntity -> {
                EntityLivingBase target = pixelmonEntity.func_70638_az();
                if (target instanceof EntityPixelmon && this.hasLegendaryPlayerOwner(target.func_110124_au(), player) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((EntityPixelmon)pixelmonEntity, player))) {
                    player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public void onBattleStarted(BattleStartedEvent event) {
        if (event.bc.isPvP()) {
            return;
        }
        ArrayList participants = event.bc.participants;
        PlayerParticipant player = participants.stream().filter(PlayerParticipant.class::isInstance).map(PlayerParticipant.class::cast).findFirst().orElse(null);
        WildPixelmonParticipant wildPixelmon = participants.stream().filter(WildPixelmonParticipant.class::isInstance).map(WildPixelmonParticipant.class::cast).findFirst().orElse(null);
        if (participants.size() == 2 && player != null && wildPixelmon != null && this.hasLegendaryPlayerOwner(wildPixelmon.getEntity().func_110124_au(), (EntityPlayerMP)player.getEntity()) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender((EntityPixelmon)wildPixelmon.getEntity(), (EntityPlayerMP)player.getEntity()))) {
            player.getEntity().func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onStartCapture(CaptureEvent.StartCapture event) {
        EntityPlayerMP player = event.player;
        if (this.hasLegendaryPlayerOwner(event.getPokemon().func_110124_au(), player) && !MinecraftForge.EVENT_BUS.post((Event)new LegendControlDefenderEvent.WorkedDefender(event.getPokemon(), player))) {
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70441_a(new ItemStack((Item)event.pokeball.getType().getItem(), 1));
            }
            player.func_145747_a((ITextComponent)UtilChat.formatMessage((String)LegendControlDefender.getInstance().getLocale().getIncorrectCause()));
            event.setCanceled(true);
        }
    }
}

