package dev.cammiescorner.fireworkfrenzy.advancement.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import dev.cammiescorner.fireworkfrenzy.util.FFCodecs;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;

public class DoBlastJumpTrigger extends class_4558<DoBlastJumpTrigger.TriggerInstance> {

	public void trigger(class_3222 player, double speed) {
		this.method_22510(player, triggerInstance -> speed >= triggerInstance.minSpeed);
	}

	@Override
	public Codec<TriggerInstance> method_54937() {
		return TriggerInstance.CODEC;
	}

	public record TriggerInstance(Optional<class_5258> player, double minSpeed) implements SimpleInstance {

		public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::player),
			FFCodecs.NON_NEGATIVE_DOUBLE.fieldOf("speed").forGetter(TriggerInstance::minSpeed)
		).apply(instance, TriggerInstance::new));

		public static class_175<TriggerInstance> hasBlastJumpSpeed(double minSpeed) {
			return FireworkFrenzyCriteriaTriggers.BLAST_JUMP.get().method_53699(new TriggerInstance(Optional.empty(), minSpeed));
		}
	}
}
