package dev.cammiescorner.fireworkfrenzy.advancement.criterion;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5699;

public class MultiJumpTrigger extends class_4558<MultiJumpTrigger.TriggerInstance> {

	public void trigger(class_3222 player, int totalJumps) {
		this.method_22510(player, triggerInstance -> totalJumps >= triggerInstance.consecutiveJumps);
	}

	@Override
	public Codec<TriggerInstance> method_54937() {
		return TriggerInstance.CODEC;
	}


	public record TriggerInstance(Optional<class_5258> player, int consecutiveJumps) implements SimpleInstance {

		public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group(
			class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::player),
			class_5699.field_33441.fieldOf("jumps").forGetter(TriggerInstance::consecutiveJumps)
		).apply(instance, TriggerInstance::new));

		public static class_175<TriggerInstance> hasConsecutiveJumps(int consecutiveJumps) {
			return FireworkFrenzyCriteriaTriggers.CONSECUTIVE_BLAST_JUMPS.get().method_53699(new TriggerInstance(Optional.empty(), consecutiveJumps));
		}
	}
}
