package dev.cammiescorner.fireworkfrenzy.component;

import dev.cammiescorner.fireworkfrenzy.FireworkFrenzyConfig;
import dev.cammiescorner.fireworkfrenzy.client.FireworkFrenzyClient;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyComponents;
import dev.cammiescorner.fireworkfrenzy.init.FireworkFrenzyCriteriaTriggers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class PlayerBlastJumper implements BlastJumper, AutoSyncedComponent, ServerTickingComponent, CommonTickingComponent {
	private static final int MAX_TIME_ON_GROUND = 100;
	private final class_1657 player;
	private boolean blastJumping = false;
	private int timeOnGround = 0;
	private int consecutiveJumps = 0;

	public PlayerBlastJumper(class_1657 player) {
		this.player = player;
	}

	@Override
	public class_1297 getEntity() {
		return player;
	}

	@Override
	public boolean isBlastJumping() {
		return blastJumping;
	}

	@Override
	public void setBlastJumping(boolean blastJumping) {
		this.blastJumping = blastJumping;

		if(blastJumping) {
			consecutiveJumps++;

			if(player instanceof class_3222 serverPlayer)
				FireworkFrenzyCriteriaTriggers.CONSECUTIVE_BLAST_JUMPS.get().trigger(serverPlayer, consecutiveJumps);
		}
	}

	@Override
	public int getTimeOnGround() {
		return timeOnGround;
	}

	@Override
	public void setTimeOnGround(int timeOnGround) {
		this.timeOnGround = class_3532.method_15340(timeOnGround, 0, MAX_TIME_ON_GROUND);
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void applySyncPacket(class_9129 buf) {
		var previous = isBlastJumping();
		AutoSyncedComponent.super.applySyncPacket(buf);

		if(!previous && isBlastJumping() && player.method_37908().method_8608())
			FireworkFrenzyClient.playBlastSound(player);
	}

	@Override
	public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
		blastJumping = tag.method_10577("blastJumping");
		timeOnGround = tag.method_10550("timeOnGround");
	}

	@Override
	public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
		tag.method_10556("blastJumping", blastJumping);
		tag.method_10569("timeOnGround", timeOnGround);
	}

	@Override
	public void tick() {
		if(isBlastJumping()) {
			if(player.method_24828() || player.method_5869()) {
				setTimeOnGround(timeOnGround + 1);

				if(this.consecutiveJumps > 0) {
					this.consecutiveJumps = 0;
					sync();
				}
			}

			if(getTimeOnGround() > 2 || player.method_5765() || (FireworkFrenzyConfig.elytraCancelsRocketJumping && player.method_6128()) || !player.method_5805() || player.method_7325() || player.method_31549().field_7479) {
				setBlastJumping(false);
				sync();
			}
		}
		else {
			timeOnGround = 0;
		}
	}

	@Override
	public void sync() {
		FireworkFrenzyComponents.BLAST_JUMPER.sync(player);
	}
}
