package dev.cammiescorner.fireworkfrenzy.datagen.common;

import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyEnchantments;
import dev.cammiescorner.fireworkfrenzy.data.FireworkFrenzyTags;
import dev.upcraft.sparkweave.api.datagen.provider.SparkweaveEnchantmentProvider;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_190;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_2248;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_7871;
import net.minecraft.class_8110;
import net.minecraft.class_8129;
import net.minecraft.class_9274;
import net.minecraft.class_9701;
import net.minecraft.class_9718;

public class FireworkFrenzyEnchantmentProvider extends SparkweaveEnchantmentProvider {
	@Override
	protected void generateEnchantments(dev.upcraft.sparkweave.api.datagen.provider.SparkweaveEnchantmentProvider.Context ctx, class_7871<class_8110> damageTypes, class_7871<class_1887> enchantments, class_7871<class_1792> items, class_7871<class_2248> blocks) {
		ctx.register(FireworkFrenzyEnchantments.AIR_STRIKE, class_1887.method_60030(
				class_1887.method_58442(
					items.method_46735(class_3489.field_48313),
					1,
					1,
					class_1887.method_58440(23),
					class_1887.method_58440(60),
					8,
					class_9274.field_49217
				))
				.method_60061(enchantments.method_46735(FireworkFrenzyTags.Enchantments.AIR_STRIKE_EXCLUSIVE_WITH)),
			"Air Strike",
			"Decreases the Crossbow charge time while rocket jumping"
		);

		ctx.register(FireworkFrenzyEnchantments.FIXED_FUSE, class_1887.method_60030(
				class_1887.method_58442(
					items.method_46735(class_3489.field_48313),
					1,
					1,
					class_1887.method_58440(23),
					class_1887.method_58440(60),
					8,
					class_9274.field_49217
				))
				.method_60061(enchantments.method_46735(FireworkFrenzyTags.Enchantments.FIXED_FUSE_EXCLUSIVE_WITH)),
			"Fixed Fuse",
			"Removes the random fuse timer from Firework Rockets, allowing for mid-air jumps"
		);

		ctx.register(FireworkFrenzyEnchantments.TAKEOFF, class_1887.method_60030(
			class_1887.method_58442(
				items.method_46735(class_3489.field_48299),
				1,
				1,
				class_1887.method_58440(23),
				class_1887.method_58440(60),
				8,
				class_9274.field_49220
			))
			.method_60061(enchantments.method_46735(FireworkFrenzyTags.Enchantments.TAKEOFF_EXCLUSIVE_WITH))
				.method_60067(class_9701.field_51660, new class_9718(), class_190.method_837(class_2022.class_2023.method_8855()
					.method_60488(false)
					.method_48785(class_8129.method_48965(FireworkFrenzyTags.DamageTypes.IS_FIREWORK))
					.method_35131(class_2048.class_2049.method_8916()
						// distance to source entity should be 0 if it is the entity itself
						.method_8924(class_2025.method_37223(class_2096.class_2099.method_35286(class_3532.field_29849)))
					)
				)),
			"Takeoff",
			"Removes self-damage from your own rockets"
		);
	}
}
